(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    142590,       3919]
NotebookOptionsPosition[    116499,       3523]
NotebookOutlinePosition[    116925,       3540]
CellTagsIndexPosition[    116882,       3537]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilGebra`"}]], "Input",
 CellChangeTimes->{{3.916306810908575*^9, 3.9163068179963284`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"970a1b2c-573e-c142-96c5-8eadc9eb8bfb"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilGebra cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
03/09/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.972058329659997*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"9b9d014f-ef57-491e-9833-1abc3e7f9f60"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operaciones entre vectores", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 
  3.972060265894546*^9}},ExpressionUUID->"0784176a-7fce-4cb4-93d2-\
7079f97c3024"],

Cell["1. 2u-3v+w", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 
   3.9721136487880793`*^9}},ExpressionUUID->"cc6088f1-c4a0-4654-8595-\
5b2d2b17c27e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "4", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "3"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"2", "*", "u"}], "-", 
  RowBox[{"3", "*", "v"}], "+", "w"}]}], "Input",
 CellChangeTimes->{{3.9721136538793697`*^9, 3.972113679928878*^9}, {
  3.972113851415563*^9, 3.972113855978109*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"6fe43d29-bce9-4c83-958a-902b032a9c9c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"13", ",", 
   RowBox[{"-", "14"}], ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972113856569377*^9, 3.972114313151425*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"0489109c-1317-4575-8dd4-055c92c8411a"]
}, Open  ]],

Cell["2. 3a+2b", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060421373118*^9, 
   3.972113867616426*^9},ExpressionUUID->"c8a653f6-deb9-4548-b077-\
318ac20f5931"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"3", "*", "a"}], "+", 
  RowBox[{"2", "*", "b"}]}]}], "Input",
 CellChangeTimes->{3.972113874578188*^9},
 CellLabel->"In[67]:=",ExpressionUUID->"eefcd5ae-e10d-49b2-a2c2-86ab07aa7276"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "4", ",", 
   RowBox[{"-", "3"}], ",", "11"}], "}"}]], "Output",
 CellChangeTimes->{3.97211387608217*^9, 3.972114392122033*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"db757b3c-8ae5-4fab-ab1e-53efc9538b83"]
}, Open  ]],

Cell["3. (5,-3,7) como combinaci\[OAcute]n lineal", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060423413022*^9, 
   3.972113886678886*^9},ExpressionUUID->"cdd10de1-31bd-4c6d-b67b-\
c8ce15ae2fcd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vector", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "3"}], ",", "7"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"j", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";", 
  RowBox[{"k", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"5", "*", "i"}], "-", 
   RowBox[{"3", "*", "j"}], "+", 
   RowBox[{"7", "*", "k"}]}], "==", "vector"}]}], "Input",
 CellChangeTimes->{{3.972113901809683*^9, 3.9721139161237164`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"b9c9afce-9b72-49ed-93a7-74e98356eff7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.972113902614129*^9, 3.97211391817875*^9}},
 CellLabel->"Out[13]=",ExpressionUUID->"4abc32a2-2a7c-46c1-a01a-2e9a5b6dcac2"]
}, Open  ]],

Cell["4. Determine \[Alpha] y \[Beta]", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060425409328*^9, 
   3.97211392761863*^9},ExpressionUUID->"4000858c-fda2-4224-bc5e-\
31f6997098ff"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"eq1", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "\[Alpha]"}], "+", 
      RowBox[{"5", "*", "\[Beta]"}]}], "==", "1"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], "*", "\[Alpha]"}], "+", "\[Beta]"}], "==", 
    RowBox[{"-", "10"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"4", "*", "\[Alpha]"}], "-", 
     RowBox[{"2", "*", "\[Beta]"}]}], "==", "14"}]}], ";"}], "\n", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eq1", ",", "eq2", ",", "eq3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.9721146233790903`*^9, 3.972114668254998*^9, {3.972114799700308*^9, 
   3.972114865154387*^9}, {3.9721149336347523`*^9, 3.9721149379255123`*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"17c0e550-ee90-43a8-8cdd-4b41a982cf34"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[Rule]", "3"}], ",", 
    RowBox[{"\[Beta]", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.972113942700439*^9, 3.972114626274673*^9, 
  3.9721146687052317`*^9, 3.972114866220078*^9, 3.9721149383527737`*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"4be90b4b-cf05-4bce-9b2b-9b1e2e6f5fff"]
}, Open  ]],

Cell["\<\
5. Verifique si los vectores u=(1,2,1),v=(2,1,0) y w=(1,-1,-1) son \
linealmente independientes\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060427839436*^9, 
   3.972114003183017*^9},ExpressionUUID->"30009be1-0f46-4b9b-b75b-\
e397b9e46884"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Alpha]", " ", "u"}], "+", 
      RowBox[{"\[Beta]", " ", "v"}]}], "==", "w"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9721140275663443`*^9, 3.972114027885721*^9}, {
  3.9721151102948236`*^9, 3.9721151565864153`*^9}, {3.9721152223189087`*^9, 
  3.972115267917678*^9}},
 CellLabel->
  "In[119]:=",ExpressionUUID->"548d640e-ec1b-44db-91e4-c8cac3ca74b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[Rule]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{"\[Beta]", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.972115257991665*^9, 3.9721152716015778`*^9}},
 CellLabel->
  "Out[122]=",ExpressionUUID->"c07c4f83-8597-403c-82fa-3fc592bf8798"]
}, Open  ]],

Cell["\<\
6. Calcule ||p||, ||q|| y el vector unitario en direcci\[OAcute]n de p\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060430131557*^9, {3.972114041570516*^9, 
   3.972114046262765*^9}},ExpressionUUID->"c23037b0-f848-422f-a626-\
c45eca5b2cad"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "3"}], ",", "12"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"normaP", "=", 
  RowBox[{"Norm", "[", "p", "]"}]}], "\n", 
 RowBox[{"normaQ", "=", 
  RowBox[{"Norm", "[", "q", "]"}]}], "\n", 
 RowBox[{"vectorUnitarioP", "=", 
  RowBox[{"p", "/", 
   RowBox[{"Norm", "[", "p", "]"}]}]}]}], "Input",
 CellLabel->
  "In[123]:=",ExpressionUUID->"b55f2712-64d2-48b4-822e-b7266ae83317"],

Cell[BoxData["13"], "Output",
 CellChangeTimes->{3.972114057675543*^9, 3.97211542401035*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"73e002f4-609e-4579-be5b-9a6a62c248ab"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.972114057675543*^9, 3.9721154240111437`*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"fb426854-0bdc-4dfe-ab16-b9fe91bc81ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["4", "13"], ",", 
   RowBox[{"-", 
    FractionBox["3", "13"]}], ",", 
   FractionBox["12", "13"]}], "}"}]], "Output",
 CellChangeTimes->{3.972114057675543*^9, 3.972115424011875*^9},
 CellLabel->
  "Out[127]=",ExpressionUUID->"705657af-dffe-4e19-973a-fe9d7523a7a0"]
}, Open  ]],

Cell["7. Calcule a\[CenterDot]b y el \[AAcute]ngulo entre los vectores", \
"Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060432504678*^9, {3.972114068724537*^9, 
   3.972114070452914*^9}},ExpressionUUID->"c8504045-69ca-43f8-b176-\
9450d5008703"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"productoEscalar", "=", 
  RowBox[{"a", ".", "b"}]}], "\n", 
 RowBox[{"cosTheta", "=", 
  RowBox[{"productoEscalar", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Norm", "[", "a", "]"}], "*", 
     RowBox[{"Norm", "[", "b", "]"}]}], ")"}]}]}], "\n", 
 RowBox[{"anguloRad", "=", 
  RowBox[{"ArcCos", "[", "cosTheta", "]"}]}], "\n", 
 RowBox[{"anguloGrados", "=", 
  RowBox[{
   RowBox[{"anguloRad", "*", 
    RowBox[{"180", "/", "Pi"}]}], "//", "N"}]}]}], "Input",
 CellChangeTimes->{{3.97211408805243*^9, 3.9721141050749474`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"ca58fff4-9eb9-4458-b08e-85507c7249c4"],

Cell[BoxData[
 RowBox[{"-", "5"}]], "Output",
 CellChangeTimes->{{3.972114102003715*^9, 3.972114105540038*^9}},
 CellLabel->"Out[42]=",ExpressionUUID->"36a99047-b168-4f35-9bae-064347ab91b6"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["5", 
   RowBox[{"6", " ", 
    SqrtBox["7"]}]]}]], "Output",
 CellChangeTimes->{{3.972114102003715*^9, 3.97211410554053*^9}},
 CellLabel->"Out[43]=",ExpressionUUID->"e5158e75-f895-46c0-ac0e-a3a9990f0575"],

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  RowBox[{"-", 
   FractionBox["5", 
    RowBox[{"6", " ", 
     SqrtBox["7"]}]]}], "]"}]], "Output",
 CellChangeTimes->{{3.972114102003715*^9, 3.972114105540986*^9}},
 CellLabel->"Out[44]=",ExpressionUUID->"51f29174-526b-4549-814f-63e3b2543964"],

Cell[BoxData["108.35902652707944`"], "Output",
 CellChangeTimes->{{3.972114102003715*^9, 3.97211410554141*^9}},
 CellLabel->"Out[45]=",ExpressionUUID->"a48fa0a9-e11d-49bf-84ef-314e282a3abd"]
}, Open  ]],

Cell["8. Proyecci\[OAcute]n", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060435010248*^9, 
   3.9721141158409853`*^9},ExpressionUUID->"a38e72ce-a8ff-4e93-a48e-\
7337a7c7d69e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"proyeccion", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", ".", "v"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"v", ".", "v"}], ")"}]}], ")"}], "*", "v"}]}]}], "Input",
 CellChangeTimes->{{3.972114129438795*^9, 3.972114138183011*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"5338648d-bdb2-4af8-a30f-822801baaa1f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", "3"], ",", 
   FractionBox["2", "3"], ",", 
   FractionBox["2", "3"]}], "}"}]], "Output",
 CellChangeTimes->{3.972114139105247*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"82b8ded1-3b62-451c-a094-ae6b09d8c088"]
}, Open  ]],

Cell["9. Calcule (a\[Times]b)\[CenterDot]c y el volumen", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060437934774*^9, 
   3.972114150890029*^9},ExpressionUUID->"cb08af21-d4f4-4f05-a8b9-\
2c8fe54c49dd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{"productoVectorial", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}], "\n", 
 RowBox[{"productoMixto", "=", 
  RowBox[{"productoVectorial", ".", "c"}]}], "\n", 
 RowBox[{"volumen", "=", 
  RowBox[{"Abs", "[", "productoMixto", "]"}]}]}], "Input",
 CellChangeTimes->{{3.972114161088017*^9, 3.972114170838489*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"8a20f327-bc65-4c0d-b59d-caef743dbcee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "4"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972114173590119*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"5152e760-307d-4dd4-bf27-723eb1512eb5"],

Cell[BoxData[
 RowBox[{"-", "19"}]], "Output",
 CellChangeTimes->{3.972114173590908*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"304f2d5d-bd8f-4fc2-be01-b9e2cdcfcca4"],

Cell[BoxData["19"], "Output",
 CellChangeTimes->{3.972114173591373*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"a5987370-0452-49e9-92df-b73400d014c3"]
}, Open  ]],

Cell["\<\
10. Encuentre un vector x tal que x\[CenterDot](1,2,1)=5, \
x\[CenterDot](2,-1,1)=3 y ||x|| =3\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060440366952*^9, {3.972114186429966*^9, 
   3.972114193803069*^9}},ExpressionUUID->"1142f5d5-5a5c-40b9-a657-\
4bd61b6eaf76"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{"x1", "+", 
     RowBox[{"2", "*", "x2"}], "+", "x3"}], "==", "5"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "*", "x1"}], "-", "x2", "+", "x3"}], "==", "3"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x1", "^", "2"}], "+", 
     RowBox[{"x2", "^", "2"}], "+", 
     RowBox[{"x3", "^", "2"}]}], "==", "9"}]}], ";"}], "\n", 
 RowBox[{"solucion10", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"eq1", ",", "eq2", ",", "eq3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", "Reals"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.97211422389585*^9, 3.9721142485108*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"45f9094b-b08d-4a9b-98b6-2f3d2274f067"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{
        FractionBox["3", "35"], " ", 
        RowBox[{"(", 
         RowBox[{"41", "-", 
          SqrtBox["141"]}], ")"}]}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       FractionBox["1", "35"], " ", 
       RowBox[{"(", 
        RowBox[{"41", "-", 
         SqrtBox["141"]}], ")"}]}]}], ",", 
     RowBox[{"x3", "\[Rule]", 
      RowBox[{"7", "+", 
       RowBox[{
        FractionBox["1", "7"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "41"}], "+", 
          SqrtBox["141"]}], ")"}]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x1", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{
        FractionBox["3", "35"], " ", 
        RowBox[{"(", 
         RowBox[{"41", "+", 
          SqrtBox["141"]}], ")"}]}]}]}], ",", 
     RowBox[{"x2", "\[Rule]", 
      RowBox[{
       FractionBox["1", "35"], " ", 
       RowBox[{"(", 
        RowBox[{"41", "+", 
         SqrtBox["141"]}], ")"}]}]}], ",", 
     RowBox[{"x3", "\[Rule]", 
      RowBox[{"7", "+", 
       RowBox[{
        FractionBox["1", "7"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "41"}], "-", 
          SqrtBox["141"]}], ")"}]}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972114209694152*^9, 3.972114249670823*^9, 
  3.972115754384523*^9, 3.972115949747315*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"00e16c89-c113-4da2-861e-3eb8851e1e8e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Productos escalares y determine ortogonalidad", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9720603101770983`*^9, 
  3.972060312651062*^9}},ExpressionUUID->"ec312b24-e38c-4539-ab2c-\
b56f17caea87"],

Cell["1. Calcule el producto escalar de u=(2,-3,1) y v=(4,1,-2)", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.9721164349646463`*^9},ExpressionUUID->"0b765cbf-5aa6-4dd1-8211-\
e430396ff081"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"u", ".", "v"}]}], "Input",
 CellLabel->
  "In[156]:=",ExpressionUUID->"538999d5-af0c-4296-a649-c89c935c7e6b"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.972116442208715*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"8147dc65-8e7c-4de8-9ac8-a7ed269320cf"]
}, Open  ]],

Cell["\<\
2. Determine si los vectores p=(3,2,-1) y q=(1,-2,4) son ortogonales\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060421373118*^9, 
   3.972116450938752*^9},ExpressionUUID->"5d6d9d54-cbdd-4ba5-8584-\
ba77a3c81d53"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "4"}], "}"}]}], ";"}], "\n", 
 RowBox[{"p", ".", "q"}]}], "Input",
 CellChangeTimes->{{3.972116459823977*^9, 3.9721164606795588`*^9}, {
  3.972117898315899*^9, 3.972117902920577*^9}},
 CellLabel->
  "In[202]:=",ExpressionUUID->"4f166ecb-5083-4637-b6dc-5b246432179a"],

Cell[BoxData[
 RowBox[{"-", "5"}]], "Output",
 CellChangeTimes->{
  3.9721164611762257`*^9, {3.972117899075892*^9, 3.97211790432732*^9}},
 CellLabel->
  "Out[204]=",ExpressionUUID->"2bb234c6-22f0-44e9-aa28-a87b2727ba77"]
}, Open  ]],

Cell["3. Calcule la norma de v=(-1,3,2,-2)", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060423413022*^9, 
   3.972116469194236*^9},ExpressionUUID->"3166ea3f-556c-46b3-a05d-\
5c8045f5ca42"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "3", ",", "2", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Norm", "[", "v", "]"}]}], "Input",
 CellLabel->
  "In[205]:=",ExpressionUUID->"119fc3b1-2382-4d2a-8c36-7648e5b779b6"],

Cell[BoxData[
 RowBox[{"3", " ", 
  SqrtBox["2"]}]], "Output",
 CellChangeTimes->{3.972116475565158*^9, 3.972117914961029*^9},
 CellLabel->
  "Out[206]=",ExpressionUUID->"4a796dd1-4502-4ae5-a098-50b5d99677e5"]
}, Open  ]],

Cell["4. Encuentre un vector unitario", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060425409328*^9, 
   3.972116483712936*^9},ExpressionUUID->"2fac4f00-c4f7-4b52-87aa-\
4fdca8a75aa9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"-", "8"}], ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Norm", "[", "w", "]"}], "\n", 
 RowBox[{"w", "/", 
  RowBox[{"Norm", "[", "w", "]"}]}]}], "Input",
 CellLabel->
  "In[164]:=",ExpressionUUID->"c52ef1e2-6349-4f4b-a40f-8758f8fe8a27"],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{3.972116492022646*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"b742d762-8bfa-42d2-b314-b437a47211d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "5"], ",", 
   RowBox[{"-", 
    FractionBox["4", "5"]}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.9721164920233088`*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"b1e59c26-f20e-4569-969c-e4200b26055c"]
}, Open  ]],

Cell["\<\
5. Calcule el \[AAcute]ngulo entre los vectores a=(1,2,2) y b=(2,-1,2)\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060427839436*^9, 
   3.9721165019391747`*^9},ExpressionUUID->"34594256-52f6-454b-8c2b-\
2b0a708b286d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{"a", ".", "b"}], "\n", 
 RowBox[{"Norm", "[", "a", "]"}], "\n", 
 RowBox[{"Norm", "[", "b", "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ArcCos", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", ".", "b"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Norm", "[", "a", "]"}], "*", 
       RowBox[{"Norm", "[", "b", "]"}]}], ")"}]}], "]"}], "*", 
   RowBox[{"180", "/", "Pi"}]}], "//", "N"}]}], "Input",
 CellChangeTimes->{{3.972116512584964*^9, 3.972116513240437*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"70f0608c-c78e-479a-a067-ac558e20aebd"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{{3.972116509226184*^9, 3.972116514087756*^9}},
 CellLabel->
  "Out[175]=",ExpressionUUID->"9294e81c-b134-4b97-90d1-c893b9ecedc4"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{{3.972116509226184*^9, 3.972116514088464*^9}},
 CellLabel->
  "Out[176]=",ExpressionUUID->"9462a712-ad66-4c5f-a1ee-42ba82b3c815"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{{3.972116509226184*^9, 3.972116514089036*^9}},
 CellLabel->
  "Out[177]=",ExpressionUUID->"05921b68-ab61-4faa-8079-a8be1d66dcae"],

Cell[BoxData["63.612200038757`"], "Output",
 CellChangeTimes->{{3.972116509226184*^9, 3.972116514089596*^9}},
 CellLabel->
  "Out[178]=",ExpressionUUID->"59049d66-ed10-422b-bef5-5980766d5196"]
}, Open  ]],

Cell["6. Encuentre un vector ortogonal", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060430131557*^9, 
   3.972116523030778*^9},ExpressionUUID->"5639797c-2278-4ac1-8edc-\
e7b705d17de7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Cross", "[", 
  RowBox[{"u", ",", "v"}], "]"}]}], "Input",
 CellLabel->
  "In[179]:=",ExpressionUUID->"44a98f04-b7e2-4d2c-be8b-41a6d38f9a6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "6"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972116529215845*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"5cc8b62f-9ad4-4a75-836a-e4198e5f4762"]
}, Open  ]],

Cell["7. Determine el valor de k", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060432504678*^9, 
   3.972116538842194*^9},ExpressionUUID->"40f7320a-f15d-4156-af27-\
97a60abdfbff"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "k", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", "*", "k"}], "+", 
     RowBox[{"k", "*", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "+", 
     RowBox[{"1", "*", "3"}]}], "==", "0"}], ",", "k"}], "]"}]}], "Input",
 CellChangeTimes->{{3.972116853340537*^9, 3.972116856924423*^9}},
 CellLabel->
  "In[197]:=",ExpressionUUID->"5f4b53ad-ee4b-45b5-9ff9-478b4e8bb494"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"k", "\[Rule]", 
    RowBox[{"-", "3"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.972116544821576*^9, 3.972116857854816*^9},
 CellLabel->
  "Out[198]=",ExpressionUUID->"9db7943e-2e49-47fc-b411-eef4f266789a"]
}, Open  ]],

Cell["\<\
8. Verifique si el conjunto {(1,1,0),(1,-1,1),(1,1,-2)} es ortogonal\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060435010248*^9, 
   3.972116575495515*^9},ExpressionUUID->"a038fd42-be27-4bd8-9d85-\
468279351c71"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"v1", ".", "v2"}], ",", 
   RowBox[{"v1", ".", "v3"}], ",", 
   RowBox[{"v2", ".", "v3"}]}], "}"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Norm", "[", "v1", "]"}], ",", 
   RowBox[{"Norm", "[", "v2", "]"}], ",", 
   RowBox[{"Norm", "[", "v3", "]"}]}], "}"}]}], "Input",
 CellLabel->
  "In[183]:=",ExpressionUUID->"9dc98df5-1480-484f-883a-9cacd210e55a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2", ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 CellChangeTimes->{3.97211658510893*^9},
 CellLabel->
  "Out[186]=",ExpressionUUID->"2b76416d-322f-4a25-a3b1-b78c2e722dde"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["2"], ",", 
   SqrtBox["3"], ",", 
   SqrtBox["6"]}], "}"}]], "Output",
 CellChangeTimes->{3.972116585110209*^9},
 CellLabel->
  "Out[187]=",ExpressionUUID->"dccbae43-8b98-4d22-85cd-f59c653b6c1b"]
}, Open  ]],

Cell["\<\
9. Dado u=(2,-1,3), encuentre la componente de u ortogonal al vector v=(1,1,1)\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060437934774*^9, {3.972116611388069*^9, 3.972116614010887*^9}, 
   3.972117140504163*^9},ExpressionUUID->"e02bce88-07e9-497d-8470-\
7a9ca8ceada6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"projv", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", ".", "v"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"v", ".", "v"}], ")"}]}], ")"}], "*", "v"}]}], "\n", 
 RowBox[{"u", "-", "projv"}]}], "Input",
 CellLabel->
  "In[188]:=",ExpressionUUID->"8e68872d-3d10-4c9d-bd9a-987d208799f1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["4", "3"], ",", 
   FractionBox["4", "3"], ",", 
   FractionBox["4", "3"]}], "}"}]], "Output",
 CellChangeTimes->{3.9721166209743147`*^9},
 CellLabel->
  "Out[190]=",ExpressionUUID->"a57c661a-c708-4f13-a823-39700ec8f134"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", "3"], ",", 
   RowBox[{"-", 
    FractionBox["7", "3"]}], ",", 
   FractionBox["5", "3"]}], "}"}]], "Output",
 CellChangeTimes->{3.972116620975511*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"c60ae676-0518-4077-874a-b2d5f6d721d6"]
}, Open  ]],

Cell["10. Demuestre", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060440366952*^9, 
   3.972116630090508*^9},ExpressionUUID->"121f45f4-1f54-45f8-8a08-\
dd78955342e9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"e1", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"e2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"e3", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "6", "]"}]}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      RowBox[{"-", "2"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Norm", "[", "e1", "]"}], ",", 
   RowBox[{"Norm", "[", "e2", "]"}], ",", 
   RowBox[{"Norm", "[", "e3", "]"}]}], "}"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"e1", ".", "e2"}], ",", 
   RowBox[{"e1", ".", "e3"}], ",", 
   RowBox[{"e2", ".", "e3"}]}], "}"}]}], "Input",
 CellLabel->
  "In[192]:=",ExpressionUUID->"57f86ed8-c058-4297-8ecd-d4d8afeaa16d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.972116637396161*^9},
 CellLabel->
  "Out[195]=",ExpressionUUID->"118756d0-2e86-4156-903e-f352ae96c03b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.9721166373970118`*^9},
 CellLabel->
  "Out[196]=",ExpressionUUID->"c69b1072-3b70-477e-b8f6-8cd6de387293"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calcule \[AAcute]ngulos y proyecciones", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9720603101770983`*^9, 
  3.9720603297089863`*^9}},ExpressionUUID->"935218d6-b013-4b12-9a11-\
780e66c5087b"],

Cell["1. \[CapitalAAcute]ngulo entre vectores", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972118416995936*^9},ExpressionUUID->"e4230a5c-d8f1-4ce8-8a52-\
6efcf3c11c92"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"cosTheta1", "=", 
  RowBox[{
   RowBox[{"u1", ".", "v1"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Norm", "[", "u1", "]"}], "*", 
     RowBox[{"Norm", "[", "v1", "]"}]}], ")"}]}]}], "\n", 
 RowBox[{"angle1", "=", 
  RowBox[{
   RowBox[{"ArcCos", "[", "cosTheta1", "]"}], "*", 
   RowBox[{"180", "/", "Pi"}]}]}]}], "Input",
 CellLabel->
  "In[207]:=",ExpressionUUID->"845c41f5-c8f9-47d5-b257-eedefecd1245"],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 CellChangeTimes->{3.972118425061173*^9},
 CellLabel->
  "Out[209]=",ExpressionUUID->"f47010b5-5a78-482a-b394-404980753cac"],

Cell[BoxData["60"], "Output",
 CellChangeTimes->{3.972118425062407*^9},
 CellLabel->
  "Out[210]=",ExpressionUUID->"3cfc20a9-71c4-4427-9e81-ea5088caa9d2"]
}, Open  ]],

Cell["2. Proyecci\[OAcute]n de vector", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060421373118*^9, 
   3.972118435937355*^9},ExpressionUUID->"04d5c83f-718b-43f3-890e-\
1ad51848ce57"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{"projBA", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", ".", "b"}], "/", 
     RowBox[{"b", ".", "b"}]}], ")"}], "*", "b"}]}]}], "Input",
 CellLabel->
  "In[211]:=",ExpressionUUID->"e18fcc72-c7e6-465c-9def-f9a73f96c2c7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["14", "5"], ",", 
   FractionBox["7", "5"], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.972118445779893*^9},
 CellLabel->
  "Out[213]=",ExpressionUUID->"68b87c5f-f324-46a1-ba0a-75c18d222506"]
}, Open  ]],

Cell["3. Cosenos directores", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060423413022*^9, 
   3.972118453477131*^9},ExpressionUUID->"0f0bec00-8945-4203-a651-\
8edeca403ab4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "6"}], "}"}]}], ";"}], "\n", 
 RowBox[{"normV", "=", 
  RowBox[{"Norm", "[", "v", "]"}]}], "\n", 
 RowBox[{"cosenosDirectores", "=", 
  RowBox[{"v", "/", "normV"}]}]}], "Input",
 CellChangeTimes->{{3.972118823518605*^9, 3.972118831305304*^9}},
 CellLabel->
  "In[270]:=",ExpressionUUID->"e5bc3382-3bcb-4df7-b218-610d9064ceee"],

Cell[BoxData["7"], "Output",
 CellChangeTimes->{3.9721184599245872`*^9, 3.972118831610574*^9},
 CellLabel->
  "Out[271]=",ExpressionUUID->"d93d79f1-fcc3-4b1f-9eb7-14ee2aa83867"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", "7"], ",", 
   FractionBox["3", "7"], ",", 
   FractionBox["6", "7"]}], "}"}]], "Output",
 CellChangeTimes->{3.9721184599245872`*^9, 3.972118831611302*^9},
 CellLabel->
  "Out[272]=",ExpressionUUID->"b255e7cc-526e-4ef7-a937-ddd414231fa5"]
}, Open  ]],

Cell["4. Vector con magnitud espec\[IAcute]fica", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060425409328*^9, 
   3.972118469827551*^9},ExpressionUUID->"163a999e-599c-4cf0-8dec-\
1b2cfb95e838"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"normU", "=", 
  RowBox[{"Norm", "[", "u", "]"}]}], "\n", 
 RowBox[{"vectorMagnitud10", "=", 
  RowBox[{"10", "*", 
   RowBox[{"u", "/", "normU"}]}]}]}], "Input",
 CellChangeTimes->{{3.972118478446353*^9, 3.97211851392129*^9}},
 CellLabel->
  "In[221]:=",ExpressionUUID->"ba6c0166-0203-4e61-af86-0856504fcbb0"],

Cell[BoxData[
 SqrtBox["21"]], "Output",
 CellChangeTimes->{{3.972118496157565*^9, 3.9721185147815933`*^9}},
 CellLabel->
  "Out[222]=",ExpressionUUID->"379f0b26-ba6b-4f9f-92b3-f3afa63b7de7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["40", 
    SqrtBox["21"]], ",", 
   RowBox[{"-", 
    FractionBox["20", 
     SqrtBox["21"]]}], ",", 
   FractionBox["10", 
    SqrtBox["21"]]}], "}"}]], "Output",
 CellChangeTimes->{{3.972118496157565*^9, 3.972118514782308*^9}},
 CellLabel->
  "Out[223]=",ExpressionUUID->"9d79c30d-45cc-49d2-ae27-32db92ebf7e3"]
}, Open  ]],

Cell["5. Valor de k para \[AAcute]ngulo de 90\[Degree]", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060427839436*^9, 
   3.972118522394371*^9},ExpressionUUID->"94c35656-bab4-471e-a510-\
1fc1a4de7fac"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"va", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "k"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vb", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"productoEscalar", "=", 
  RowBox[{"va", ".", "vb"}]}], "\n", 
 RowBox[{"solucionK", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"productoEscalar", "==", "0"}], ",", "k"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.972118531142981*^9, 3.9721185361816273`*^9}},
 CellLabel->
  "In[224]:=",ExpressionUUID->"f9c6a6b9-4f2d-487e-8f27-ebb7bd0a42de"],

Cell[BoxData[
 RowBox[{"4", "-", "k"}]], "Output",
 CellChangeTimes->{3.972118540379649*^9},
 CellLabel->
  "Out[226]=",ExpressionUUID->"907ee61c-22c3-4265-8e1e-67e43874e5da"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"k", "\[Rule]", "4"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.972118540380892*^9},
 CellLabel->
  "Out[227]=",ExpressionUUID->"8b049ec1-48e8-4b96-8dd9-7006416339a0"]
}, Open  ]],

Cell["6. Componente perpendicular", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060430131557*^9, 
   3.972118551461533*^9},ExpressionUUID->"bd1ddfdb-ee87-4160-b204-\
373596a29bd0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"projVU", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"u", ".", "v"}], "/", 
     RowBox[{"v", ".", "v"}]}], ")"}], "*", "v"}]}], "\n", 
 RowBox[{"componentePerpendicular", "=", 
  RowBox[{"u", "-", "projVU"}]}]}], "Input",
 CellChangeTimes->{{3.972118558548264*^9, 3.972118578708181*^9}},
 CellLabel->
  "In[228]:=",ExpressionUUID->"0bf6e133-117d-49a1-a215-08e39447d545"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["7", "3"], ",", 
   FractionBox["7", "3"], ",", 
   FractionBox["7", "3"]}], "}"}]], "Output",
 CellChangeTimes->{3.97211857945395*^9},
 CellLabel->
  "Out[230]=",ExpressionUUID->"78eae2cd-dd96-487f-ac9e-707a1c2fa5c7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["8", "3"], ",", 
   RowBox[{"-", 
    FractionBox["10", "3"]}], ",", 
   FractionBox["2", "3"]}], "}"}]], "Output",
 CellChangeTimes->{3.972118579455332*^9},
 CellLabel->
  "Out[231]=",ExpressionUUID->"3c0e8a66-8893-4eb9-b96c-68446bf1c7ab"]
}, Open  ]],

Cell["7. \[CapitalAAcute]ngulo agudo entre vectores", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060432504678*^9, 
   3.972118587553746*^9},ExpressionUUID->"53871e3b-4fef-4e2a-82be-\
7a8d3c7119a2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{"cosTheta", "=", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", ".", "b"}], "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Norm", "[", "a", "]"}], "*", 
     RowBox[{"Norm", "[", "b", "]"}]}], ")"}]}]}], "\n", 
 RowBox[{"angle", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCos", "[", "cosTheta", "]"}], "*", 
    RowBox[{"180", "/", "Pi"}]}], "//", "N"}]}]}], "Input",
 CellChangeTimes->{{3.9721185941763372`*^9, 3.972118613014323*^9}},
 CellLabel->
  "In[273]:=",ExpressionUUID->"2f100758-4096-472c-91c1-8d289c3f535d"],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["15"]]], "Output",
 CellChangeTimes->{{3.9721186095645723`*^9, 3.972118613775054*^9}, 
   3.972119077437928*^9},
 CellLabel->
  "Out[275]=",ExpressionUUID->"3ba3ce59-eb95-4593-b357-db8a9c6da614"],

Cell[BoxData["75.03678256669288`"], "Output",
 CellChangeTimes->{{3.9721186095645723`*^9, 3.972118613775054*^9}, 
   3.9721190774385033`*^9},
 CellLabel->
  "Out[276]=",ExpressionUUID->"ef1132dd-e11a-4e7c-929e-65aaead7ccb4"]
}, Open  ]],

Cell["8. Normas de proyecciones", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060435010248*^9, 
   3.972118622009946*^9},ExpressionUUID->"d698692a-29bc-43fd-a968-\
cd90114afad4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "5"}], ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{"productoEscalar", "=", 
  RowBox[{"u", ".", "v"}]}], "\n", 
 RowBox[{"normProjVU", "=", 
  RowBox[{
   RowBox[{"Abs", "[", "productoEscalar", "]"}], "/", 
   RowBox[{"Norm", "[", "v", "]"}]}]}], "\n", 
 RowBox[{"normProjUV", "=", 
  RowBox[{
   RowBox[{"Abs", "[", "productoEscalar", "]"}], "/", 
   RowBox[{"Norm", "[", "u", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.972118630427753*^9, 3.972118647353756*^9}, {
  3.972119133236258*^9, 3.972119135991424*^9}},
 CellLabel->
  "In[277]:=",ExpressionUUID->"6b0bbef7-f647-45e1-8684-87cfaa627ca9"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["3", "5"]}]], "Output",
 CellChangeTimes->{3.972118649862138*^9, 3.972119136960485*^9},
 CellLabel->
  "Out[279]=",ExpressionUUID->"9ae4955d-98b4-402c-a8ad-747023d3d92c"],

Cell[BoxData[
 FractionBox["3", 
  SqrtBox["134"]]], "Output",
 CellChangeTimes->{3.972118649862138*^9, 3.972119136961409*^9},
 CellLabel->
  "Out[280]=",ExpressionUUID->"c1227185-4888-4973-86a8-8d5bfe439df4"],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["3", "2"]], "5"]], "Output",
 CellChangeTimes->{3.972118649862138*^9, 3.972119136962144*^9},
 CellLabel->
  "Out[281]=",ExpressionUUID->"87ff4b41-e0d9-41b7-8b97-f5978e4ab118"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.972119267158257*^9, 
  3.9721192685031033`*^9}},ExpressionUUID->"dd2dfb49-f915-4a62-a1e3-\
9fb003a21763"],

Cell["9. Vector unitario con \[AAcute]ngulos iguales", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060437934774*^9, 
   3.972118665526987*^9},ExpressionUUID->"7e542ce2-be7b-41cc-a6f8-\
ad8e70060ed8"],

Cell[TextData[{
 "Sea v=(x,y,z) el vector unitario buscado. Los cosenos directores son las \
componentes del vector unitario: cos \[Alpha]=x, cos \[Beta]=y, cos \
\[Gamma]=z. Luego: x\.b2+y\.b2+z\.b2=1. Sabemos que cos \[Alpha]=cos \
\[Beta]=cos \[Gamma]. Esto significa:x=y=z. Entonces: x\.b2+x\.b2+x\.b2=1, 3x\
\.b2=1, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{
     RowBox[{"\[PlusMinus]", "1"}], "/", 
     SqrtBox["3"]}]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "b4cb2181-3349-44dd-965e-054bcaaa55d2"],
 ". De donde: x=1/",
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]],ExpressionUUID->
  "065f0eb1-0122-4089-9841-349a5541bd14"],
 ",\ny=1/",
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]],ExpressionUUID->
  "4be2479e-048d-45c2-a70f-4f465ae6a10c"],
 " y z=1/",
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]],ExpressionUUID->
  "9c6ff15b-a3c0-46c1-8d45-6126d1f7d093"],
 "."
}], "Text",
 CellChangeTimes->{{3.972119620138382*^9, 
  3.9721198216938257`*^9}},ExpressionUUID->"4d822c3d-1ad5-4605-8ec1-\
14f99d87415f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"vectorUnitario", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "/", 
   RowBox[{"Sqrt", "[", "3", "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"j", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";", 
  RowBox[{"k", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"anguloConI", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCos", "[", 
     RowBox[{"vectorUnitario", ".", "i"}], "]"}], "*", 
    RowBox[{"180", "/", "Pi"}]}], "//", "N"}]}], "\n", 
 RowBox[{"anguloConJ", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCos", "[", 
     RowBox[{"vectorUnitario", ".", "j"}], "]"}], "*", 
    RowBox[{"180", "/", "Pi"}]}], "//", "N"}]}], "\n", 
 RowBox[{"anguloConK", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCos", "[", 
     RowBox[{"vectorUnitario", ".", "k"}], "]"}], "*", 
    RowBox[{"180", "/", "Pi"}]}], "//", "N"}]}]}], "Input",
 CellChangeTimes->{{3.972118682409184*^9, 3.9721186916347113`*^9}},
 CellLabel->
  "In[250]:=",ExpressionUUID->"fe02086d-e42b-4990-9db3-263b18af2bd5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["3"]], ",", 
   FractionBox["1", 
    SqrtBox["3"]], ",", 
   FractionBox["1", 
    SqrtBox["3"]]}], "}"}]], "Output",
 CellChangeTimes->{{3.972118677575192*^9, 3.972118692394291*^9}},
 CellLabel->
  "Out[250]=",ExpressionUUID->"72e283b7-c46e-4fc6-ad15-d4b55a07c10e"],

Cell[BoxData["54.735610317245346`"], "Output",
 CellChangeTimes->{{3.972118677575192*^9, 3.97211869239511*^9}},
 CellLabel->
  "Out[252]=",ExpressionUUID->"75f5e9df-2384-4aee-832b-4de612dd6dcc"],

Cell[BoxData["54.735610317245346`"], "Output",
 CellChangeTimes->{{3.972118677575192*^9, 3.9721186923957148`*^9}},
 CellLabel->
  "Out[253]=",ExpressionUUID->"0d2bf8fd-db1c-4b8f-8d90-549e79bc444f"],

Cell[BoxData["54.735610317245346`"], "Output",
 CellChangeTimes->{{3.972118677575192*^9, 3.972118692396294*^9}},
 CellLabel->
  "Out[254]=",ExpressionUUID->"fdf14316-3977-42cb-babe-234666812e53"]
}, Open  ]],

Cell["10. \[CapitalAAcute]ngulo complejo con proyecci\[OAcute]n", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060440366952*^9, 
   3.9721187034932327`*^9},ExpressionUUID->"48a70ce9-11f4-4042-8ff5-\
46e36e91a66a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"projCB", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"b", ".", "c"}], "/", 
     RowBox[{"c", ".", "c"}]}], ")"}], "*", "c"}]}], "\n", 
 RowBox[{"bPerpC", "=", 
  RowBox[{"b", "-", "projCB"}]}], "\n", 
 RowBox[{"cosTheta", "=", 
  RowBox[{
   RowBox[{"a", ".", "bPerpC"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Norm", "[", "a", "]"}], "*", 
     RowBox[{"Norm", "[", "bPerpC", "]"}]}], ")"}]}]}], "\n", 
 RowBox[{"angle", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCos", "[", "cosTheta", "]"}], "*", 
    RowBox[{"180", "/", "Pi"}]}], "//", "N"}]}]}], "Input",
 CellChangeTimes->{{3.972118713712483*^9, 3.972118757534812*^9}},
 CellLabel->
  "In[283]:=",ExpressionUUID->"0d648433-e3a0-49c9-8c47-fdb674124481"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Output",
 CellChangeTimes->{{3.972118746697569*^9, 3.972118758587604*^9}, 
   3.972120212954473*^9},
 CellLabel->
  "Out[286]=",ExpressionUUID->"1bc8ded5-5d84-47fa-8b89-49ea7141d2e9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["1", "2"], ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.972118746697569*^9, 3.972118758587604*^9}, 
   3.972120212955847*^9},
 CellLabel->
  "Out[287]=",ExpressionUUID->"65036961-7ee8-46b6-87dd-35c877d979a1"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"2", " ", 
   SqrtBox["3"]}]]], "Output",
 CellChangeTimes->{{3.972118746697569*^9, 3.972118758587604*^9}, 
   3.9721202129568377`*^9},
 CellLabel->
  "Out[288]=",ExpressionUUID->"e7b76616-27a3-4f45-b1ab-a4f310e86586"],

Cell[BoxData["73.22134511903964`"], "Output",
 CellChangeTimes->{{3.972118746697569*^9, 3.972118758587604*^9}, 
   3.972120212957739*^9},
 CellLabel->
  "Out[289]=",ExpressionUUID->"17ef89f9-2728-4902-b5af-ff633c2eb892"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calcule productos vectoriales", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
   3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
   3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
   3.972060262404065*^9, 3.972060265894546*^9}, {3.9720603101770983`*^9, 
   3.972060347017128*^9}, 
   3.972060377338707*^9},ExpressionUUID->"af5dd942-c7d8-4bd8-8420-\
19ec64c957eb"],

Cell["1. Producto vectorial b\[AAcute]sico", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.9721203845750723`*^9},ExpressionUUID->"6574cb87-c7b1-4b3e-920c-\
c36a4469d4cb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Cross", "[", 
  RowBox[{"u", ",", "v"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9721203921992292`*^9, 3.9721204006615562`*^9}},
 CellLabel->
  "In[290]:=",ExpressionUUID->"b4c590ee-fe9d-4418-a9fd-07ded606d155"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "5"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9721204009957438`*^9},
 CellLabel->
  "Out[292]=",ExpressionUUID->"a45a00e7-6d25-41e3-8fa1-3bff7761055f"]
}, Open  ]],

Cell["2. Verificar ortogonalidad", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060421373118*^9, 
   3.972120412890955*^9},ExpressionUUID->"ba6a160b-9c3c-4dc7-a3a9-\
de5fb4493417"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"crossProduct", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}], "\n", 
 RowBox[{"a", ".", "crossProduct"}], "\n", 
 RowBox[{"b", ".", "crossProduct"}]}], "Input",
 CellChangeTimes->{{3.972120420341413*^9, 3.9721204565370407`*^9}},
 CellLabel->
  "In[293]:=",ExpressionUUID->"322c7c58-247e-4b00-8036-79c5b5d0d6a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", "7", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.972120457333063*^9},
 CellLabel->
  "Out[295]=",ExpressionUUID->"045b018f-1ee3-4ae8-80d7-7158992bf33a"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.972120457334477*^9},
 CellLabel->
  "Out[296]=",ExpressionUUID->"8db4b832-7dbf-4c2d-b9c1-cdcbbe7146a1"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9721204573351593`*^9},
 CellLabel->
  "Out[297]=",ExpressionUUID->"cc01a4b7-7355-46d1-8d14-5003ef6cce57"]
}, Open  ]],

Cell["3. \[CapitalAAcute]rea del paralelogramo", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060423413022*^9, 
   3.972120466925749*^9},ExpressionUUID->"8c28b97a-2583-45a4-9cb4-\
2f763516a293"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"crossProduct", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}], "\n", 
 RowBox[{"area", "=", 
  RowBox[{"Norm", "[", "crossProduct", "]"}]}]}], "Input",
 CellChangeTimes->{{3.97212047531774*^9, 3.972120486284594*^9}},
 CellLabel->
  "In[298]:=",ExpressionUUID->"f4478518-0384-4bc8-8b73-98f6cbfe12db"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "2", ",", "5"}], "}"}]], "Output",
 CellChangeTimes->{3.9721204867532883`*^9},
 CellLabel->
  "Out[300]=",ExpressionUUID->"7014226c-e8ad-4779-b6b0-86c3f868cf75"],

Cell[BoxData[
 SqrtBox["30"]], "Output",
 CellChangeTimes->{3.9721204867542353`*^9},
 CellLabel->
  "Out[301]=",ExpressionUUID->"e37ed5d0-f9c0-40fa-8040-2ea25f5be438"]
}, Open  ]],

Cell["4. Producto vectorial triple", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060425409328*^9, 
   3.972120496935039*^9},ExpressionUUID->"bf2dd9db-c185-4c39-8c35-\
6c977d921e34"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{"vCrossW", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"v", ",", "w"}], "]"}]}], "\n", 
 RowBox[{"result", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"u", ",", "vCrossW"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.972120506354357*^9, 3.972120515864974*^9}},
 CellLabel->
  "In[369]:=",ExpressionUUID->"e2124730-511b-4ac4-be98-98fc50ac973a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "4"}], ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{3.972120518251341*^9, 3.972121047705052*^9},
 CellLabel->
  "Out[372]=",ExpressionUUID->"f65262ae-5c02-4e20-a4d3-0052b56d14b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "1", ",", 
   RowBox[{"-", "4"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972120518251341*^9, 3.9721210477059383`*^9},
 CellLabel->
  "Out[373]=",ExpressionUUID->"b471ef5d-3f99-4cd0-83e9-829bbda6001c"]
}, Open  ]],

Cell["5. \[CapitalAAcute]rea del tri\[AAcute]ngulo", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060427839436*^9, 
   3.972120526704393*^9},ExpressionUUID->"8baf1e2e-68a9-449b-bc19-\
1fb535c69f71"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{"AB", "=", 
  RowBox[{"B", "-", "A"}]}], "\n", 
 RowBox[{"AC", "=", 
  RowBox[{"c", "-", "A"}]}], "\n", 
 RowBox[{"crossProduct", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"AB", ",", "AC"}], "]"}]}], "\n", 
 RowBox[{"areaTriangle", "=", 
  RowBox[{
   RowBox[{"Norm", "[", "crossProduct", "]"}], "/", "2"}]}]}], "Input",
 CellChangeTimes->{{3.97212053395392*^9, 3.972120552132415*^9}},
 CellLabel->
  "In[374]:=",ExpressionUUID->"c2d5700f-0ba0-4a45-9ba5-004e3ed7021c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972120553081635*^9, 3.972121154876913*^9},
 CellLabel->
  "Out[377]=",ExpressionUUID->"703b2c33-7348-482c-a839-9aecc916d14d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.972120553081635*^9, 3.972121154877508*^9},
 CellLabel->
  "Out[378]=",ExpressionUUID->"5e5d9878-cf45-4593-bb45-69ee68df707c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972120553081635*^9, 3.9721211548779373`*^9},
 CellLabel->
  "Out[379]=",ExpressionUUID->"657e4ad6-b2b9-4425-a45c-ea420beb0935"],

Cell[BoxData[
 SqrtBox[
  FractionBox["13", "2"]]], "Output",
 CellChangeTimes->{3.972120553081635*^9, 3.97212115487838*^9},
 CellLabel->
  "Out[380]=",ExpressionUUID->"e72ee88d-23b3-4eec-a1f9-f254e605a7c7"]
}, Open  ]],

Cell["6. Vector unitario perpendicular", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060430131557*^9, 
   3.972120563840275*^9},ExpressionUUID->"f94153ee-9bec-41b5-8147-\
398ac92a94f9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{"crossProduct", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"p", ",", "q"}], "]"}]}], "\n", 
 RowBox[{"unitVector", "=", 
  RowBox[{"crossProduct", "/", 
   RowBox[{"Norm", "[", "crossProduct", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.972120571017969*^9, 3.9721205844722757`*^9}},
 CellLabel->
  "In[318]:=",ExpressionUUID->"35915402-5798-460c-8666-d841a98c9157"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"-", "5"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.972120582099616*^9, 3.972120584869151*^9}},
 CellLabel->
  "Out[320]=",ExpressionUUID->"c0943728-e16e-4be7-bb4b-19a8de2c0550"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["30"]], ",", 
   SqrtBox[
    FractionBox["2", "15"]], ",", 
   RowBox[{"-", 
    SqrtBox[
     FractionBox["5", "6"]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.972120582099616*^9, 3.972120584869965*^9}},
 CellLabel->
  "Out[321]=",ExpressionUUID->"75fa6671-19d8-41f6-87b3-0c6b7cd3aa48"]
}, Open  ]],

Cell["7. Volumen del paralelep\[IAcute]pedo", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060432504678*^9, 
   3.972120592953218*^9},ExpressionUUID->"c0e8acd9-6b5a-4c93-a1f8-\
898050d4e9df"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"bCrossC", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"b", ",", "c"}], "]"}]}], "\n", 
 RowBox[{"volumen", "=", 
  RowBox[{"Abs", "[", 
   RowBox[{"a", ".", "bCrossC"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.972120599653832*^9, 3.9721206219387703`*^9}},
 CellLabel->
  "In[327]:=",ExpressionUUID->"99464b06-d6a8-44f4-b1a3-496630ddb488"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.972120612474105*^9, 3.972120624254436*^9}},
 CellLabel->
  "Out[330]=",ExpressionUUID->"7862a359-2bf3-4b18-af6a-016c4d545703"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{{3.972120612474105*^9, 3.972120624255508*^9}},
 CellLabel->
  "Out[331]=",ExpressionUUID->"78521564-8ce2-41c9-ba9e-f61ff8c88c76"]
}, Open  ]],

Cell["8. Verificaci\[OAcute]n de identidad", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060435010248*^9, 
   3.972120633449663*^9},ExpressionUUID->"26f24df3-e2c2-45bf-b6ed-\
805d16399037"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"aCrossB", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}], "\n", 
 RowBox[{"bCrossC", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"b", ",", "c"}], "]"}]}], "\n", 
 RowBox[{"leftSide", "=", 
  RowBox[{"aCrossB", ".", "c"}]}], "\n", 
 RowBox[{"rightSide", "=", 
  RowBox[{"a", ".", "bCrossC"}]}]}], "Input",
 CellChangeTimes->{{3.972120642103169*^9, 3.9721206604635878`*^9}},
 CellLabel->
  "In[332]:=",ExpressionUUID->"6fa4eddb-6c70-45d1-a396-fd18185a21c3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{3.97212066084663*^9},
 CellLabel->
  "Out[335]=",ExpressionUUID->"b635a5a0-0101-43fd-a587-adafa39c0c01"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "5", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972120660848131*^9},
 CellLabel->
  "Out[336]=",ExpressionUUID->"69c9e4fb-5acf-48a0-bb4e-8f00a75c2c30"],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{3.972120660848872*^9},
 CellLabel->
  "Out[337]=",ExpressionUUID->"dce552b1-c4fd-4db9-9153-11c443330a6e"],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{3.9721206608496313`*^9},
 CellLabel->
  "Out[338]=",ExpressionUUID->"f7e11c91-1aae-4209-b4f5-55c7ed92b9a3"]
}, Open  ]],

Cell["9. Vectores coplanares", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060437934774*^9, 
   3.9721206698484993`*^9},ExpressionUUID->"e6159bf1-ad23-49a4-9da4-\
cefd61564ffc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "k", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "k", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "k"}], ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "k", ",", "k"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"det", "=", 
  RowBox[{"Det", "[", 
   RowBox[{"{", 
    RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], "]"}]}], "\n", 
 RowBox[{"equation", "=", 
  RowBox[{"det", "==", "0"}]}], "\n", 
 RowBox[{"solutions", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{"equation", ",", "k", ",", "Reals"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.972120691726231*^9, 3.972120773716404*^9}, {
   3.972121680450811*^9, 3.972121686629971*^9}, {3.972121746254341*^9, 
   3.97212179672959*^9}, 3.972121859625342*^9, {3.9721219784908867`*^9, 
   3.972122003196816*^9}, 3.9721221532141523`*^9},
 CellLabel->
  "In[470]:=",ExpressionUUID->"e342ad4f-9686-433c-846a-dd0465d450e4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], "+", "k", "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["k", "2"]}], "+", 
  SuperscriptBox["k", "3"]}]], "Output",
 CellChangeTimes->{{3.972120727937986*^9, 3.972120774523683*^9}, 
   3.972121698830855*^9, 3.972121765417049*^9, 3.972121798185255*^9, 
   3.972121867180532*^9, {3.972121979325469*^9, 3.972122003680081*^9}, 
   3.972122050796036*^9, 3.9721221536653976`*^9},
 CellLabel->
  "Out[474]=",ExpressionUUID->"6c38c1ed-d7b3-4db8-b317-310600d13543"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "4"}], "+", "k", "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["k", "2"]}], "+", 
   SuperscriptBox["k", "3"]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.972120727937986*^9, 3.972120774523683*^9}, 
   3.972121698830855*^9, 3.972121765417049*^9, 3.972121798185255*^9, 
   3.972121867180532*^9, {3.972121979325469*^9, 3.972122003680081*^9}, 
   3.972122050796036*^9, 3.97212215366654*^9},
 CellLabel->
  "Out[475]=",ExpressionUUID->"961b01c9-c810-4edb-b545-23531c142b27"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"k", "\[Rule]", "1"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.972120727937986*^9, 3.972120774523683*^9}, 
   3.972121698830855*^9, 3.972121765417049*^9, 3.972121798185255*^9, 
   3.972121867180532*^9, {3.972121979325469*^9, 3.972122003680081*^9}, 
   3.972122050796036*^9, 3.972122153667418*^9},
 CellLabel->
  "Out[476]=",ExpressionUUID->"f75e2e27-0a8d-44e2-9972-988a52e1c967"]
}, Open  ]],

Cell["10. Sistema de ecuaci\[OAcute]n vectorial", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060440366952*^9, 
   3.9721207964738283`*^9},ExpressionUUID->"8adb4b62-67c8-4520-b80e-\
8421374932c7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"dotProduct", "=", 
  RowBox[{"u", ".", "v"}]}]}], "Input",
 CellChangeTimes->{{3.972120806689295*^9, 3.972120821865818*^9}},
 CellLabel->
  "In[366]:=",ExpressionUUID->"a22c3662-6ae5-4c36-9782-25223e965104"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.972120832361928*^9},
 CellLabel->
  "Out[368]=",ExpressionUUID->"b06df7dd-3780-4d4e-906a-500985c88353"]
}, Open  ]],

Cell["Como u \[CenterDot] v \[NotEqual] 0, no existe soluci\[OAcute]n para u \
\[Times] w = v", "Text",
 CellChangeTimes->{
  3.972120865931901*^9},ExpressionUUID->"cc788f00-8804-4105-9534-\
ffb810efdf49"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Problemas de geometr\[IAcute]a anal\[IAcute]tica", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9720603101770983`*^9, 
  3.972060367148005*^9}},ExpressionUUID->"2789ca2a-e041-4afc-8f33-\
b77376725dc9"],

Cell["1. \[CapitalAAcute]rea del tri\[AAcute]ngulo", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972122486121521*^9},ExpressionUUID->"69990c91-64a8-4235-8bfa-\
180b905d262a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AB", "=", 
   RowBox[{"B", "-", "A"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AC", "=", 
   RowBox[{"c", "-", "A"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"crossProduct", "=", 
   RowBox[{"Cross", "[", 
    RowBox[{"AB", ",", "AC"}], "]"}]}], ";"}], "\n", 
 RowBox[{"area", "=", 
  RowBox[{
   RowBox[{"Norm", "[", "crossProduct", "]"}], "/", "2"}]}]}], "Input",
 CellChangeTimes->{{3.972122495668276*^9, 3.972122519432325*^9}},
 CellLabel->
  "In[484]:=",ExpressionUUID->"a5541379-4b74-400e-b469-fa7a87914faf"],

Cell[BoxData[
 SqrtBox[
  FractionBox["13", "2"]]], "Output",
 CellChangeTimes->{{3.972122517127816*^9, 3.9721225198789454`*^9}},
 CellLabel->
  "Out[490]=",ExpressionUUID->"1d33374a-5443-4096-950c-ef3c951f2486"]
}, Open  ]],

Cell["2. Volumen del tetraedro", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060421373118*^9, 
   3.972122575659959*^9},ExpressionUUID->"35194434-9448-416e-b878-\
891d9ed920d4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"R", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"S", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"PQ", "=", 
   RowBox[{"Q", "-", "P"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"PR", "=", 
   RowBox[{"R", "-", "P"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"PS", "=", 
   RowBox[{"S", "-", "P"}]}], ";"}], "\n", 
 RowBox[{"volumen", "=", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{"PQ", ",", "PR", ",", "PS"}], "}"}], "]"}], "]"}], "/", 
   "6"}]}]}], "Input",
 CellChangeTimes->{{3.972122583047274*^9, 3.972122609272781*^9}},
 CellLabel->
  "In[491]:=",ExpressionUUID->"08460816-172a-4c5d-992c-2fffaa6cff56"],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 CellChangeTimes->{3.972122609669456*^9},
 CellLabel->
  "Out[498]=",ExpressionUUID->"7788f2df-adb0-44b0-9461-109582acb048"]
}, Open  ]],

Cell["3. Puntos colineales", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060423413022*^9, 
   3.972122623297155*^9},ExpressionUUID->"efe95b09-a610-49ab-bf7b-\
d8c83740009c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "4"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AB", "=", 
   RowBox[{"B", "-", "A"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AC", "=", 
   RowBox[{"c", "-", "A"}]}], ";"}], "\n", 
 RowBox[{"crossProduct", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"AB", ",", "AC"}], "]"}]}], "\n", 
 RowBox[{"isCollinear", "=", 
  RowBox[{
   RowBox[{"Norm", "[", "crossProduct", "]"}], "==", "0"}]}]}], "Input",
 CellChangeTimes->{{3.9721226318357687`*^9, 3.9721226546812973`*^9}, 
   3.972123317580901*^9},
 CellLabel->
  "In[560]:=",ExpressionUUID->"3cc11143-9a85-4446-b11e-0550f1314586"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "0", ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9721226691314783`*^9, 3.972123317966094*^9},
 CellLabel->
  "Out[565]=",ExpressionUUID->"5402f3d5-82e7-47a7-8d1f-522bb8e0f823"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.9721226691314783`*^9, 3.97212331796758*^9},
 CellLabel->
  "Out[566]=",ExpressionUUID->"85eb88d5-676e-4800-b636-e1c1b2ecc008"]
}, Open  ]],

Cell["4. Distancia punto a recta", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060425409328*^9, 
   3.972122679717774*^9},ExpressionUUID->"16d95082-088f-47e7-8763-\
3e97ae952260"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"QP", "=", 
   RowBox[{"P", "-", "Q"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"crossProduct", "=", 
   RowBox[{"Cross", "[", 
    RowBox[{"QP", ",", "v"}], "]"}]}], ";"}], "\n", 
 RowBox[{"distance", "=", 
  RowBox[{
   RowBox[{"Norm", "[", "crossProduct", "]"}], "/", 
   RowBox[{"Norm", "[", "v", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.9721226872784357`*^9, 3.9721227061469193`*^9}},
 CellLabel->
  "In[506]:=",ExpressionUUID->"2bc7efb7-7146-4528-bd21-2836a11ba551"],

Cell[BoxData[
 SqrtBox["6"]], "Output",
 CellChangeTimes->{3.9721227068237963`*^9},
 CellLabel->
  "Out[511]=",ExpressionUUID->"a6d5e06a-6a59-4dc3-864e-c1fea811239e"]
}, Open  ]],

Cell["5. Distancia punto a plano", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060427839436*^9, 
   3.9721227175988417`*^9},ExpressionUUID->"608faf7a-8781-48e7-8e5d-\
2badd74bb619"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"normalVector", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"d", "=", "9"}], ";"}], "\n", 
 RowBox[{"distance", "=", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"normalVector", ".", "P"}], "-", "d"}], "]"}], "/", 
   RowBox[{"Norm", "[", "normalVector", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.972122728259391*^9, 3.972122766642808*^9}},
 CellLabel->
  "In[518]:=",ExpressionUUID->"73ed53ff-45ab-4055-b49b-febd33498af0"],

Cell[BoxData[
 FractionBox["2", "3"]], "Output",
 CellChangeTimes->{{3.972122762227672*^9, 3.972122767749893*^9}},
 CellLabel->
  "Out[521]=",ExpressionUUID->"c567c080-8875-492b-9be5-24f534ac61cb"]
}, Open  ]],

Cell["6. \[CapitalAAcute]ngulo entre planos", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060430131557*^9, 
   3.972122774942439*^9},ExpressionUUID->"e8a422f1-f22e-497c-9ec2-\
6d45057b4ef9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"normala", "=", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"normalb", "=", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"dotProduct", "=", 
   RowBox[{"normala", ".", "normalb"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"cosTheta", "=", 
   RowBox[{
    RowBox[{"Abs", "[", "dotProduct", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Norm", "[", "normala", "]"}], "*", 
      RowBox[{"Norm", "[", "normalb", "]"}]}], ")"}]}]}], ";"}], "\n", 
 RowBox[{"angle", "=", 
  RowBox[{
   RowBox[{"ArcCos", "[", "cosTheta", "]"}], "*", 
   RowBox[{"180", "/", "Pi"}]}]}]}], "Input",
 CellChangeTimes->{{3.972122784944862*^9, 3.972122823753187*^9}, 
   3.972123449687499*^9},
 CellLabel->
  "In[567]:=",ExpressionUUID->"fff8527c-6ad1-4984-b195-6e34505067ee"],

Cell[BoxData["90"], "Output",
 CellChangeTimes->{{3.972122820355426*^9, 3.972122824055336*^9}, 
   3.972123450014454*^9},
 CellLabel->
  "Out[571]=",ExpressionUUID->"07a49a52-3187-4efd-a2d9-d3e15a0ed7e3"]
}, Open  ]],

Cell["7. Intersecci\[OAcute]n recta-plano", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060432504678*^9, 
   3.9721228385045967`*^9},ExpressionUUID->"2d169ab2-e2b3-402f-997d-\
355d31e6388e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"2", "*", "t"}], "-", "1", "-", "t", "+", "t"}], "==", "2"}], 
      ",", "t"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"intersection", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", "*", "t"}]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "t"}], ",", "t"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.972122847045734*^9, 3.972122858417535*^9}},
 CellLabel->
  "In[532]:=",ExpressionUUID->"4efa9670-a5eb-4f0f-9737-608658a86db6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"-", "2"}], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.9721228587801857`*^9},
 CellLabel->
  "Out[533]=",ExpressionUUID->"72ce5c82-83bb-41b1-ad82-ee1f10d6cc16"]
}, Open  ]],

Cell["8. Distancia entre rectas", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060435010248*^9, 
   3.9721228788988123`*^9},ExpressionUUID->"fdf6dd99-e888-4e9a-9d98-\
3d20f5674e9b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "t", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pa", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"da", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Pb", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"db", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "5"}], ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Pa", "+", 
      RowBox[{"t", " ", "da"}]}], "==", 
     RowBox[{"Pb", "+", 
      RowBox[{"s", " ", "db"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "s"}], "}"}]}], "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Las", " ", "rectas", " ", "son", " ", "paralelas"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"dist", "=", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"Cross", "[", 
     RowBox[{"da", ",", 
      RowBox[{"Pb", "-", "Pa"}]}], "]"}], "]"}], "/", 
   RowBox[{"Norm", "[", "da", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.972122907694107*^9, 3.9721229658450527`*^9}, {
   3.9721235716688004`*^9, 3.972123586308815*^9}, 3.97212363960783*^9, {
   3.972123715402958*^9, 3.972123746558784*^9}, {3.972123780131177*^9, 
   3.972123780476821*^9}, {3.972124035733308*^9, 3.9721240825030622`*^9}, {
   3.97212746774899*^9, 3.9721274731037283`*^9}, {3.972127667031042*^9, 
   3.972127676644045*^9}, {3.972129122943625*^9, 3.972129132995605*^9}},
 CellLabel->
  "In[798]:=",ExpressionUUID->"8ce88d5a-b24f-4626-8602-07ff1ed28d17"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.972122966247417*^9, 3.9721235869087276`*^9, 
  3.9721236400404663`*^9, 3.972123746984202*^9, 3.972123780789085*^9, 
  3.972124083273039*^9, 3.972127528904655*^9, 3.972129133970817*^9},
 CellLabel->
  "Out[803]=",ExpressionUUID->"f54dd372-9754-4c38-887a-6348faedd0aa"],

Cell[BoxData[
 SqrtBox["3"]], "Output",
 CellChangeTimes->{3.972122966247417*^9, 3.9721235869087276`*^9, 
  3.9721236400404663`*^9, 3.972123746984202*^9, 3.972123780789085*^9, 
  3.972124083273039*^9, 3.972127528904655*^9, 3.972129133972355*^9},
 CellLabel->
  "Out[804]=",ExpressionUUID->"bb41f670-1e37-407c-9635-a2217b8d2bed"]
}, Open  ]],

Cell["9. Plano perpendicular a intersecci\[OAcute]n", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060437934774*^9, 
   3.9721229900792103`*^9},ExpressionUUID->"4732a54f-ec86-4e06-a49d-\
a27f129e2ad5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"normala", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"normalb", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"direccionInterseccion", "=", 
   RowBox[{"Cross", "[", 
    RowBox[{"normala", ",", "normalb"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"punto", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ecuacionPlano", "=", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{"direccionInterseccion", ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "-", "punto"}], ")"}]}], 
    "]"}], "==", "0"}]}]}], "Input",
 CellChangeTimes->{{3.9721230025366592`*^9, 3.972123041284979*^9}, {
  3.9721242578836308`*^9, 3.972124278117703*^9}},
 CellLabel->
  "In[614]:=",ExpressionUUID->"4a7c8861-e0e0-4d8a-9178-8a2fad784905"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], " ", "y"}], "-", 
   RowBox[{"3", " ", "z"}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{
  3.9721230416541767`*^9, {3.972124268052771*^9, 3.972124278499057*^9}},
 CellLabel->
  "Out[618]=",ExpressionUUID->"0339c73e-7f79-4905-b130-83493c84b6c8"]
}, Open  ]],

Cell["10. Ecuaci\[OAcute]n de la esfera", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060440366952*^9, 
   3.972123050289064*^9},ExpressionUUID->"da14dfea-c4e5-4afe-b167-\
3cc457feaaf7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"puntos", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{"{", 
    RowBox[{"h", ",", "k", ",", "l", ",", "r"}], "}"}]}], ";"}], "\n", 
 RowBox[{"ecuaciones", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"puntos", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], "-", "h"}], ")"}], "^", 
       "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"puntos", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "-", "k"}], ")"}], "^", 
       "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"puntos", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}], "-", "l"}], ")"}], "^", 
       "2"}]}], "==", 
     RowBox[{"r", "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], "\n", 
 RowBox[{"solucion", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"ecuaciones", ",", "vars"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\n", 
 RowBox[{"centro", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"h", ",", "k", ",", "l"}], "}"}], "/.", " ", "solucion"}]}], "\n", 
 RowBox[{"radio", "=", 
  RowBox[{"r", "/.", " ", "solucion"}]}]}], "Input",
 CellChangeTimes->{{3.972123070687334*^9, 3.97212310952129*^9}, 
   3.972123164752261*^9, 3.972124813051002*^9},
 CellLabel->
  "In[619]:=",ExpressionUUID->"63ed080d-da70-4893-a582-b89cc37f8ca9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "h"}], ")"}], "2"], "+", 
     SuperscriptBox["k", "2"], "+", 
     SuperscriptBox["l", "2"]}], "\[Equal]", 
    SuperscriptBox["r", "2"]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "k"}], ")"}], "2"], "+", 
     SuperscriptBox["l", "2"]}], "\[Equal]", 
    SuperscriptBox["r", "2"]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", "2"], "+", 
     SuperscriptBox["k", "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "l"}], ")"}], "2"]}], "\[Equal]", 
    SuperscriptBox["r", "2"]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["h", "2"], "+", 
     SuperscriptBox["k", "2"], "+", 
     SuperscriptBox["l", "2"]}], "\[Equal]", 
    SuperscriptBox["r", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.972123110297497*^9, 3.972123165230929*^9, 
  3.9721248134727373`*^9},
 CellLabel->
  "Out[621]=",ExpressionUUID->"23fa301d-c0b5-49ba-9630-52c29327882d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"h", "\[Rule]", 
    FractionBox["1", "2"]}], ",", 
   RowBox[{"k", "\[Rule]", 
    FractionBox["1", "2"]}], ",", 
   RowBox[{"l", "\[Rule]", 
    FractionBox["1", "2"]}], ",", 
   RowBox[{"r", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      SqrtBox["3"], "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.972123110297497*^9, 3.972123165230929*^9, 
  3.9721248134742393`*^9},
 CellLabel->
  "Out[622]=",ExpressionUUID->"cba9f63e-b698-42ab-b7f5-d8dd3a7438ca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Output",
 CellChangeTimes->{3.972123110297497*^9, 3.972123165230929*^9, 
  3.972124813475127*^9},
 CellLabel->
  "Out[623]=",ExpressionUUID->"e6bf8dc0-64c0-4652-829f-9efb522d3a08"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SqrtBox["3"], "2"]}]], "Output",
 CellChangeTimes->{3.972123110297497*^9, 3.972123165230929*^9, 
  3.972124813475943*^9},
 CellLabel->
  "Out[624]=",ExpressionUUID->"7572e882-f063-489d-92de-ac176b854906"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ecuaciones de rectas y planos", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9720603101770983`*^9, 
  3.972060367148005*^9}, {3.972060399715219*^9, 
  3.972060402218689*^9}},ExpressionUUID->"d78bddbb-eb89-4c2b-99f7-\
77202085bb1f"],

Cell["1. Ecuaciones param\[EAcute]tricas de recta", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972124881630972*^9},ExpressionUUID->"355f9366-5d57-4aec-af5c-\
dd9a9217ad49"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P1", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"P2", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{"vectorDirector1", "=", 
  RowBox[{"P2", "-", "P1"}]}], "\[IndentingNewLine]", 
 RowBox[{"P1", "+", 
  RowBox[{"t", " ", "vectorDirector1"}]}]}], "Input",
 CellChangeTimes->{{3.972124894715077*^9, 3.972124933179467*^9}, {
  3.972125660194242*^9, 3.972125662875993*^9}},
 CellLabel->
  "In[695]:=",ExpressionUUID->"a7d90461-9d17-490c-a77d-37b3cc490806"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9721249077020082`*^9, 3.972124933921549*^9}, 
   3.972125663276696*^9},
 CellLabel->
  "Out[697]=",ExpressionUUID->"4f929b1d-0406-4a91-abd4-5b02ed73b0a5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"2", " ", "t"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "t"}]}], ",", 
   RowBox[{"3", "-", 
    RowBox[{"3", " ", "t"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9721249077020082`*^9, 3.972124933921549*^9}, 
   3.972125663277766*^9},
 CellLabel->
  "Out[698]=",ExpressionUUID->"095e85f5-4c11-401e-97f3-96deb734cfff"]
}, Open  ]],

Cell["2. Ecuaci\[OAcute]n del plano", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060421373118*^9, 
   3.9721249479331713`*^9},ExpressionUUID->"98f0ed6a-8695-4020-94c1-\
034862ea539c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"punto", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"normal", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"constante", "=", 
   RowBox[{"normal", ".", "punto"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"normal", ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "==", "constante"}]}], "Input",
 CellChangeTimes->{{3.972124960628018*^9, 3.972124996584241*^9}},
 CellLabel->
  "In[632]:=",ExpressionUUID->"fd0f3435-fc6e-45d0-b76d-78c0cc4ff194"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "x"}], "-", "y", "+", 
   RowBox[{"3", " ", "z"}]}], "\[Equal]", "8"}]], "Output",
 CellChangeTimes->{3.9721249973687963`*^9},
 CellLabel->
  "Out[635]=",ExpressionUUID->"80cec4ef-f23d-490b-ada8-57ed12b1e6e9"]
}, Open  ]],

Cell["3. Intersecci\[OAcute]n de planos", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060423413022*^9, 
   3.9721250079204187`*^9},ExpressionUUID->"fbb7bae3-9e2c-4507-9104-\
28e4286ee206"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "-", "z"}], "==", "2"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", "z"}], "==", "1"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.97212575937866*^9, 3.972125781140408*^9}},
 CellLabel->
  "In[704]:=",ExpressionUUID->"f1f7b384-5f69-4b07-bba8-b02d9eccb4ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.972125782485641*^9},
 CellLabel->
  "Out[704]=",ExpressionUUID->"dfce4159-d13c-4883-9fc5-7d043474673a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"normala", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"normalb", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{"direccion", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"normala", ",", "normalb"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"puntoInterseccion", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"puntoInterseccion", "+", 
  RowBox[{"t", " ", "direccion"}]}]}], "Input",
 CellChangeTimes->{{3.9721250164608583`*^9, 3.972125102118022*^9}, 
   3.972125723612381*^9, {3.972125789873901*^9, 3.9721258094771633`*^9}},
 CellLabel->
  "In[710]:=",ExpressionUUID->"f950b82a-6990-4b83-b45e-1aafcfd4ffca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.972125102956509*^9, 3.972125723962821*^9, {3.9721257925928183`*^9, 
   3.9721258100514793`*^9}},
 CellLabel->
  "Out[712]=",ExpressionUUID->"bd0073cd-09d7-4720-9c05-6d0248e80458"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"-", "3"}], " ", "t"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"3", " ", "t"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.972125102956509*^9, 3.972125723962821*^9, {3.9721257925928183`*^9, 
   3.9721258100531282`*^9}},
 CellLabel->
  "Out[714]=",ExpressionUUID->"730710c6-9baa-43cb-9e91-8129c853f375"]
}, Open  ]],

Cell["4. Distancia punto a plano", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060425409328*^9, 
   3.972125113011217*^9},ExpressionUUID->"e3f3e31d-5d18-4480-b3bb-\
8adadf8376e5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"punto", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"normal", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"d", "=", "4"}], ";"}], "\n", 
 RowBox[{"distancia", "=", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"normal", ".", "punto"}], "-", "d"}], "]"}], "/", 
   RowBox[{"Norm", "[", "normal", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.972125122440167*^9, 3.9721251418797417`*^9}},
 CellLabel->
  "In[641]:=",ExpressionUUID->"b29e97e4-79fe-454f-b195-56bcb6ecfa63"],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["14"]]], "Output",
 CellChangeTimes->{3.972125142578553*^9},
 CellLabel->
  "Out[644]=",ExpressionUUID->"47f8516d-73bf-4bfe-a71f-150c6c0bf6e9"]
}, Open  ]],

Cell["5. \[CapitalAAcute]ngulo entre planos", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060427839436*^9, 
   3.972125152225831*^9},ExpressionUUID->"f8723f94-be0e-4658-a16a-\
b0660c968c3e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"normala", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"normalb", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{"cosAngulo", "=", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"normala", ".", "normalb"}], "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Norm", "[", "normala", "]"}], "*", 
     RowBox[{"Norm", "[", "normalb", "]"}]}], ")"}]}]}], "\n", 
 RowBox[{"angulo", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCos", "[", "cosAngulo", "]"}], "*", 
    RowBox[{"180", "/", "Pi"}]}], "//", "N"}]}]}], "Input",
 CellChangeTimes->{{3.972125160542388*^9, 3.972125182622265*^9}, 
   3.972125880370091*^9},
 CellLabel->
  "In[719]:=",ExpressionUUID->"75119c49-467e-4258-b11d-9ff39ca92cd7"],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   FractionBox["2", "3"]], "3"]], "Output",
 CellChangeTimes->{
  3.9721251833121233`*^9, {3.972125880746455*^9, 3.9721259073851147`*^9}},
 CellLabel->
  "Out[721]=",ExpressionUUID->"56708573-036d-4704-bc85-be1613aab2f6"],

Cell[BoxData["74.20683095173604`"], "Output",
 CellChangeTimes->{
  3.9721251833121233`*^9, {3.972125880746455*^9, 3.972125907386869*^9}},
 CellLabel->
  "Out[722]=",ExpressionUUID->"794ffa9c-43de-4c15-8e9e-f1fbc7e421b9"]
}, Open  ]],

Cell["6. Distancia entre rectas", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060430131557*^9, 
   3.972125194221471*^9},ExpressionUUID->"ce46e8df-a668-4de0-86f6-\
dc8df44d09a1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Pa", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"da", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Pb", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"db", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Pa", "+", 
   RowBox[{"s", " ", "da"}]}], "==", 
  RowBox[{"Pb", "+", 
   RowBox[{"t", " ", "db"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Pa", "+", 
      RowBox[{"t", " ", "da"}]}], "==", 
     RowBox[{"Pb", "+", 
      RowBox[{"s", " ", "db"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "s"}], "}"}]}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Las", " ", "rectas", " ", "son", " ", "alabeadas"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Pb", "-", "Pa"}], ")"}], ".", 
    RowBox[{"Cross", "[", 
     RowBox[{"da", ",", "db"}], "]"}]}], "]"}], "/", 
  RowBox[{"Norm", "[", 
   RowBox[{"Cross", "[", 
    RowBox[{"da", ",", "db"}], "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.972125246417865*^9, 3.972125308054377*^9}, {
  3.972125344700346*^9, 3.972125353313817*^9}, {3.972126023804847*^9, 
  3.972126026252275*^9}, {3.9721264355597486`*^9, 3.9721264650361557`*^9}, {
  3.9721265672925367`*^9, 3.972126571491448*^9}, {3.972126611589913*^9, 
  3.9721266250513077`*^9}, {3.972127692696767*^9, 3.972127762104885*^9}, {
  3.972127826609336*^9, 3.972127855096859*^9}, {3.972127981776619*^9, 
  3.972128013968917*^9}, {3.972128945190763*^9, 3.972129011581294*^9}},
 CellLabel->
  "In[791]:=",ExpressionUUID->"dbb9fc13-8b2b-4c3b-a7cc-d702c61b9de0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "+", "s"}], ",", "s", ",", "1"}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"2", ",", 
    RowBox[{"1", "+", "t"}], ",", "t"}], "}"}]}]], "Output",
 CellChangeTimes->{
  3.972125354234791*^9, 3.972126041357231*^9, 3.972126472556443*^9, 
   3.972126573531719*^9, {3.972126612200692*^9, 3.972126625371201*^9}, 
   3.972127856348217*^9, 3.972128014980444*^9, 3.97212896026849*^9, 
   3.972129012572773*^9},
 CellLabel->
  "Out[795]=",ExpressionUUID->"e93066b5-8449-415e-bd54-5f01e6b29aef"],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{
  3.972125354234791*^9, 3.972126041357231*^9, 3.972126472556443*^9, 
   3.972126573531719*^9, {3.972126612200692*^9, 3.972126625371201*^9}, 
   3.972127856348217*^9, 3.972128014980444*^9, 3.97212896026849*^9, 
   3.972129012574377*^9},
 CellLabel->
  "Out[796]=",ExpressionUUID->"b7b85d3e-2788-443f-ae38-fc31073f947c"],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["3"]]], "Output",
 CellChangeTimes->{
  3.972125354234791*^9, 3.972126041357231*^9, 3.972126472556443*^9, 
   3.972126573531719*^9, {3.972126612200692*^9, 3.972126625371201*^9}, 
   3.972127856348217*^9, 3.972128014980444*^9, 3.97212896026849*^9, 
   3.9721290125753107`*^9},
 CellLabel->
  "Out[797]=",ExpressionUUID->"d506a530-2e66-482a-987d-1fd53b6173fb"]
}, Open  ]],

Cell["7. Plano que contiene recta", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060432504678*^9, 
   3.972125369033531*^9},ExpressionUUID->"b20ea475-dee8-48ce-abef-\
13b2ba459989"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"puntoRecta", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"direccionRecta", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"puntoExterno", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vectorAdicional", "=", 
   RowBox[{"puntoExterno", "-", "puntoRecta"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"normalPlano", "=", 
   RowBox[{"Cross", "[", 
    RowBox[{"direccionRecta", ",", "vectorAdicional"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"constantePlano", "=", 
   RowBox[{"normalPlano", ".", "puntoExterno"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"normalPlano", ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "==", 
  "constantePlano"}]}], "Input",
 CellChangeTimes->{{3.972125383208764*^9, 3.972125431341448*^9}},
 CellLabel->
  "In[812]:=",ExpressionUUID->"be72bb6c-ee91-4767-b8a8-fe7079bbdd00"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"3", " ", "x"}], "-", 
   RowBox[{"6", " ", "y"}]}], "\[Equal]", "9"}]], "Output",
 CellChangeTimes->{3.9721254322368927`*^9, 3.9721293674774723`*^9, 
  3.972129412327509*^9},
 CellLabel->
  "Out[818]=",ExpressionUUID->"a12add64-27ed-44d8-8c68-22974493652a"]
}, Open  ]],

Cell["8. Intersecci\[OAcute]n recta-plano", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060435010248*^9, 
   3.972125442721424*^9},ExpressionUUID->"dbad2805-9369-4f3d-8a14-\
efb43364719d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"puntoRecta", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"direccionRecta", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ecuacionParametro", "=", 
   RowBox[{
    RowBox[{"2", "+", "t", "+", "1", "-", "t", "+", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "+", 
     RowBox[{"2", "*", "t"}]}], "==", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"solucionT", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"ecuacionParametro", ",", "t"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"puntoInterseccion", "=", 
  RowBox[{"puntoRecta", "+", 
   RowBox[{"solucionT", "*", "direccionRecta"}]}]}]}], "Input",
 CellChangeTimes->{{3.972125452299181*^9, 3.972125480828889*^9}},
 CellLabel->
  "In[820]:=",ExpressionUUID->"8f6dd99c-fb75-4998-af61-b4b60e07a162"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "0", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.9721296011181097`*^9},
 CellLabel->
  "Out[824]=",ExpressionUUID->"60bd1867-7421-4a16-9e9d-b8b64eabab3f"]
}, Open  ]],

Cell["9. Proyecci\[OAcute]n ortogonal de recta sobre plano", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060437934774*^9, 
   3.97212548922279*^9},ExpressionUUID->"5f7db296-3e2b-4e5c-a65c-\
ef1cd5cc374b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", "t_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "t"}], ",", "t", ",", 
     RowBox[{"2", "+", "t"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vn", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Lambda]", "[", "t_", "]"}], ":=", 
   RowBox[{"\[Lambda]", "/.", " ", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"P", "[", "t", "]"}], "-", 
           RowBox[{"\[Lambda]", " ", "n"}]}], ")"}], ".", "n"}], "==", "3"}], 
       ",", "\[Lambda]"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Q", "[", "t_", "]"}], ":=", 
  RowBox[{
   RowBox[{"P", "[", "t", "]"}], "-", 
   RowBox[{
    RowBox[{"\[Lambda]", "[", "t", "]"}], " ", "vn"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", 
  RowBox[{"Q", "[", "t", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.97212550258084*^9, 3.972125553894137*^9}, {
  3.9721300897892637`*^9, 3.972130335736287*^9}, {3.972130376811862*^9, 
  3.972130379765306*^9}, {3.972130417399876*^9, 3.97213041814942*^9}},
 CellLabel->
  "In[904]:=",ExpressionUUID->"cb1a71b5-d7f4-454e-ace7-3c3eba013ab2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"2", " ", "t"}], "3"]}], ",", 
   FractionBox[
    RowBox[{"4", " ", "t"}], "3"], ",", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", "t"}], ")"}]}], "3"]}], "}"}]], "Output",
 CellChangeTimes->{{3.972125545485207*^9, 3.9721255542214317`*^9}, {
  3.972130116447096*^9, 3.97213018033454*^9}, {3.972130218863858*^9, 
  3.972130267740436*^9}, {3.972130315454043*^9, 3.9721303360927134`*^9}, {
  3.972130414004174*^9, 3.972130419531188*^9}},
 CellLabel->
  "Out[908]=",ExpressionUUID->"d232fdf7-bea1-4acc-8ace-d3ae75c53693"]
}, Open  ]],

Cell["10. Recta perpendicular a dos rectas", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, 
   3.972060440366952*^9, 
   3.9721255656157427`*^9},ExpressionUUID->"5b83cb80-b023-4d1f-906c-\
f9431fa9e019"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"puntoFinal", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"direcciona", "=", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"direccionb", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"direccionPerpendicular", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"direcciona", ",", "direccionb"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"puntoFinal", "+", 
  RowBox[{"t", " ", "direccionPerpendicular"}]}]}], "Input",
 CellChangeTimes->{{3.9721255732932673`*^9, 3.97212561617043*^9}, {
  3.972131217193276*^9, 3.972131225251522*^9}},
 CellLabel->
  "In[909]:=",ExpressionUUID->"847a619e-acff-4c61-85ab-027f6db3866b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "3", ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{3.972125579199316*^9, 3.972125616557413*^9, 
  3.972131231412239*^9},
 CellLabel->
  "Out[912]=",ExpressionUUID->"c637b6d7-7a9c-49db-a67a-2c230b1fa138"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", "t"}], ",", 
   RowBox[{"2", "+", 
    RowBox[{"3", " ", "t"}]}], ",", 
   RowBox[{"3", "+", "t"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972125579199316*^9, 3.972125616557413*^9, 
  3.9721312314142513`*^9},
 CellLabel->
  "Out[913]=",ExpressionUUID->"dedc5cc3-c38f-455b-b411-336a44b48804"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1319, 776},
WindowMargins->{{131, Automatic}, {Automatic, 11}},
Magnification:>1.25 Inherited,
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b14c32af-361e-497c-b469-f48e546e10d9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 199, 3, 73, "Input",ExpressionUUID->"970a1b2c-573e-c142-96c5-8eadc9eb8bfb"],
Cell[782, 27, 1003, 30, 107, "Print",ExpressionUUID->"9b9d014f-ef57-491e-9833-1abc3e7f9f60"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1822, 62, 369, 6, 165, "Section",ExpressionUUID->"0784176a-7fce-4cb4-93d2-7079f97c3024"],
Cell[2194, 70, 426, 7, 84, "Text",ExpressionUUID->"cc6088f1-c4a0-4654-8595-5b2d2b17c27e"],
Cell[CellGroupData[{
Cell[2645, 81, 696, 21, 226, "Input",ExpressionUUID->"6fe43d29-bce9-4c83-958a-902b032a9c9c"],
Cell[3344, 104, 266, 6, 83, "Output",ExpressionUUID->"0489109c-1317-4575-8dd4-055c92c8411a"]
}, Open  ]],
Cell[3625, 113, 418, 7, 84, "Text",ExpressionUUID->"c8a653f6-deb9-4548-b077-318ac20f5931"],
Cell[CellGroupData[{
Cell[4068, 124, 500, 15, 175, "Input",ExpressionUUID->"eefcd5ae-e10d-49b2-a2c2-86ab07aa7276"],
Cell[4571, 141, 255, 5, 83, "Output",ExpressionUUID->"db757b3c-8ae5-4fab-ab1e-53efc9538b83"]
}, Open  ]],
Cell[4841, 149, 453, 7, 84, "Text",ExpressionUUID->"cdd10de1-31bd-4c6d-b67b-c8ce15ae2fcd"],
Cell[CellGroupData[{
Cell[5319, 160, 739, 22, 175, "Input",ExpressionUUID->"b9c9afce-9b72-49ed-93a7-74e98356eff7"],
Cell[6061, 184, 175, 2, 83, "Output",ExpressionUUID->"4abc32a2-2a7c-46c1-a01a-2e9a5b6dcac2"]
}, Open  ]],
Cell[6251, 189, 440, 7, 84, "Text",ExpressionUUID->"4000858c-fda2-4224-bc5e-31f6997098ff"],
Cell[CellGroupData[{
Cell[6716, 200, 1003, 30, 259, "Input",ExpressionUUID->"17c0e550-ee90-43a8-8cdd-4b41a982cf34"],
Cell[7722, 232, 409, 9, 83, "Output",ExpressionUUID->"4be90b4b-cf05-4bce-9b2b-9b1e2e6f5fff"]
}, Open  ]],
Cell[8146, 244, 513, 10, 139, "Text",ExpressionUUID->"30009be1-0f46-4b9b-b75b-e397b9e46884"],
Cell[CellGroupData[{
Cell[8684, 258, 932, 28, 259, "Input",ExpressionUUID->"548d640e-ec1b-44db-91e4-c8cac3ca74b4"],
Cell[9619, 288, 344, 9, 83, "Output",ExpressionUUID->"c07c4f83-8597-403c-82fa-3fc592bf8798"]
}, Open  ]],
Cell[9978, 300, 512, 9, 84, "Text",ExpressionUUID->"c23037b0-f848-422f-a626-c45eca5b2cad"],
Cell[CellGroupData[{
Cell[10515, 313, 604, 19, 385, "Input",ExpressionUUID->"b55f2712-64d2-48b4-822e-b7266ae83317"],
Cell[11122, 334, 175, 3, 83, "Output",ExpressionUUID->"73e002f4-609e-4579-be5b-9a6a62c248ab"],
Cell[11300, 339, 177, 3, 83, "Output",ExpressionUUID->"fb426854-0bdc-4dfe-ab16-b9fe91bc81ac"],
Cell[11480, 344, 320, 9, 104, "Output",ExpressionUUID->"705657af-dffe-4e19-973a-fe9d7523a7a0"]
}, Open  ]],
Cell[11815, 356, 500, 8, 84, "Text",ExpressionUUID->"c8504045-69ca-43f8-b176-9450d5008703"],
Cell[CellGroupData[{
Cell[12340, 368, 899, 26, 436, "Input",ExpressionUUID->"ca58fff4-9eb9-4458-b08e-85507c7249c4"],
Cell[13242, 396, 190, 3, 83, "Output",ExpressionUUID->"36a99047-b168-4f35-9bae-064347ab91b6"],
Cell[13435, 401, 248, 6, 115, "Output",ExpressionUUID->"e5158e75-f895-46c0-ac0e-a3a9990f0575"],
Cell[13686, 409, 285, 7, 115, "Output",ExpressionUUID->"51f29174-526b-4549-814f-63e3b2543964"],
Cell[13974, 418, 190, 2, 83, "Output",ExpressionUUID->"a48fa0a9-e11d-49bf-84ef-314e282a3abd"]
}, Open  ]],
Cell[14179, 423, 433, 7, 84, "Text",ExpressionUUID->"a38e72ce-a8ff-4e93-a48e-7337a7c7d69e"],
Cell[CellGroupData[{
Cell[14637, 434, 624, 19, 175, "Input",ExpressionUUID->"5338648d-bdb2-4af8-a30f-822801baaa1f"],
Cell[15264, 455, 270, 7, 104, "Output",ExpressionUUID->"82b8ded1-3b62-451c-a094-ae6b09d8c088"]
}, Open  ]],
Cell[15549, 465, 459, 7, 84, "Text",ExpressionUUID->"cb08af21-d4f4-4f05-a8b9-2c8fe54c49dd"],
Cell[CellGroupData[{
Cell[16033, 476, 805, 23, 398, "Input",ExpressionUUID->"8a20f327-bc65-4c0d-b59d-caef743dbcee"],
Cell[16841, 501, 242, 6, 83, "Output",ExpressionUUID->"5152e760-307d-4dd4-bf27-723eb1512eb5"],
Cell[17086, 509, 167, 3, 83, "Output",ExpressionUUID->"304f2d5d-bd8f-4fc2-be01-b9e2cdcfcca4"],
Cell[17256, 514, 150, 2, 83, "Output",ExpressionUUID->"a5987370-0452-49e9-92df-b73400d014c3"]
}, Open  ]],
Cell[17421, 519, 536, 10, 84, "Text",ExpressionUUID->"1142f5d5-5a5c-40b9-a657-4bd61b6eaf76"],
Cell[CellGroupData[{
Cell[17982, 533, 889, 28, 259, "Input",ExpressionUUID->"45f9094b-b08d-4a9b-98b6-2f3d2274f067"],
Cell[18874, 563, 1605, 54, 260, "Output",ExpressionUUID->"00e16c89-c113-4da2-861e-3eb8851e1e8e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20528, 623, 436, 6, 258, "Section",ExpressionUUID->"ec312b24-e38c-4539-ab2c-b56f17caea87"],
Cell[20967, 631, 443, 6, 84, "Text",ExpressionUUID->"0b765cbf-5aa6-4dd1-8211-e430396ff081"],
Cell[CellGroupData[{
Cell[21435, 641, 396, 13, 175, "Input",ExpressionUUID->"538999d5-af0c-4296-a649-c89c935c7e6b"],
Cell[21834, 656, 153, 3, 83, "Output",ExpressionUUID->"8147dc65-8e7c-4de8-9ac8-a7ed269320cf"]
}, Open  ]],
Cell[22002, 662, 486, 9, 84, "Text",ExpressionUUID->"5d6d9d54-cbdd-4ba5-8584-ba77a3c81d53"],
Cell[CellGroupData[{
Cell[22513, 675, 513, 15, 175, "Input",ExpressionUUID->"4f166ecb-5083-4637-b6dc-5b246432179a"],
Cell[23029, 692, 220, 5, 83, "Output",ExpressionUUID->"2bb234c6-22f0-44e9-aa28-a87b2727ba77"]
}, Open  ]],
Cell[23264, 700, 446, 7, 84, "Text",ExpressionUUID->"3166ea3f-556c-46b3-a05d-5c8045f5ca42"],
Cell[CellGroupData[{
Cell[23735, 711, 304, 9, 156, "Input",ExpressionUUID->"119fc3b1-2382-4d2a-8c36-7648e5b779b6"],
Cell[24042, 722, 209, 5, 84, "Output",ExpressionUUID->"4a796dd1-4502-4ae5-a098-50b5d99677e5"]
}, Open  ]],
Cell[24266, 730, 441, 7, 84, "Text",ExpressionUUID->"2fac4f00-c4f7-4b52-87aa-4fdca8a75aa9"],
Cell[CellGroupData[{
Cell[24732, 741, 337, 10, 245, "Input",ExpressionUUID->"c52ef1e2-6349-4f4b-a40f-8758f8fe8a27"],
Cell[25072, 753, 154, 3, 83, "Output",ExpressionUUID->"b742d762-8bfa-42d2-b314-b437a47211d0"],
Cell[25229, 758, 274, 8, 104, "Output",ExpressionUUID->"b1e59c26-f20e-4569-969c-e4200b26055c"]
}, Open  ]],
Cell[25518, 769, 490, 9, 84, "Text",ExpressionUUID->"34594256-52f6-454b-8c2b-2b0a708b286d"],
Cell[CellGroupData[{
Cell[26033, 782, 844, 26, 436, "Input",ExpressionUUID->"70f0608c-c78e-479a-a067-ac558e20aebd"],
Cell[26880, 810, 177, 3, 83, "Output",ExpressionUUID->"9294e81c-b134-4b97-90d1-c893b9ecedc4"],
Cell[27060, 815, 177, 3, 83, "Output",ExpressionUUID->"9462a712-ad66-4c5f-a1ee-42ba82b3c815"],
Cell[27240, 820, 177, 3, 83, "Output",ExpressionUUID->"05921b68-ab61-4faa-8079-a8be1d66dcae"],
Cell[27420, 825, 192, 3, 84, "Output",ExpressionUUID->"59049d66-ed10-422b-bef5-5980766d5196"]
}, Open  ]],
Cell[27627, 831, 442, 7, 84, "Text",ExpressionUUID->"5639797c-2278-4ac1-8edc-e7b705d17de7"],
Cell[CellGroupData[{
Cell[28094, 842, 407, 13, 207, "Input",ExpressionUUID->"44a98f04-b7e2-4d2c-be8b-41a6d38f9a6d"],
Cell[28504, 857, 246, 7, 83, "Output",ExpressionUUID->"5cc8b62f-9ad4-4a75-836a-e4198e5f4762"]
}, Open  ]],
Cell[28765, 867, 436, 7, 84, "Text",ExpressionUUID->"40f7320a-f15d-4156-af27-97a60abdfbff"],
Cell[CellGroupData[{
Cell[29226, 878, 479, 13, 194, "Input",ExpressionUUID->"5f4b53ad-ee4b-45b5-9ff9-478b4e8bb494"],
Cell[29708, 893, 270, 7, 83, "Output",ExpressionUUID->"9db7943e-2e49-47fc-b411-eef4f266789a"]
}, Open  ]],
Cell[29993, 903, 486, 9, 84, "Text",ExpressionUUID->"a038fd42-be27-4bd8-9d85-468279351c71"],
Cell[CellGroupData[{
Cell[30504, 916, 785, 26, 310, "Input",ExpressionUUID->"9dc98df5-1480-484f-883a-9cacd210e55a"],
Cell[31292, 944, 226, 6, 83, "Output",ExpressionUUID->"2b76416d-322f-4a25-a3b1-b78c2e722dde"],
Cell[31521, 952, 247, 8, 88, "Output",ExpressionUUID->"dccbae43-8b98-4d22-85cd-f59c653b6c1b"]
}, Open  ]],
Cell[31783, 963, 542, 9, 139, "Text",ExpressionUUID->"e02bce88-07e9-497d-8470-7a9ca8ceada6"],
Cell[CellGroupData[{
Cell[32350, 976, 594, 20, 226, "Input",ExpressionUUID->"8e68872d-3d10-4c9d-bd9a-987d208799f1"],
Cell[32947, 998, 276, 8, 104, "Output",ExpressionUUID->"a57c661a-c708-4f13-a823-39700ec8f134"],
Cell[33226, 1008, 294, 9, 104, "Output",ExpressionUUID->"c60ae676-0518-4077-874a-b2d5f6d721d6"]
}, Open  ]],
Cell[33535, 1020, 423, 7, 84, "Text",ExpressionUUID->"121f45f4-1f54-45f8-8a08-dd78955342e9"],
Cell[CellGroupData[{
Cell[33983, 1031, 1123, 38, 427, "Input",ExpressionUUID->"57f86ed8-c058-4297-8ecd-d4d8afeaa16d"],
Cell[35109, 1071, 208, 5, 83, "Output",ExpressionUUID->"118756d0-2e86-4156-903e-f352ae96c03b"],
Cell[35320, 1078, 210, 5, 83, "Output",ExpressionUUID->"c69b1072-3b70-477e-b8f6-8cd6de387293"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35579, 1089, 431, 6, 165, "Section",ExpressionUUID->"935218d6-b013-4b12-9a11-780e66c5087b"],
Cell[36013, 1097, 423, 6, 84, "Text",ExpressionUUID->"e4230a5c-d8f1-4ce8-8a52-6efcf3c11c92"],
Cell[CellGroupData[{
Cell[36461, 1107, 662, 21, 296, "Input",ExpressionUUID->"845c41f5-c8f9-47d5-b257-eedefecd1245"],
Cell[37126, 1130, 173, 4, 104, "Output",ExpressionUUID->"f47010b5-5a78-482a-b394-404980753cac"],
Cell[37302, 1136, 154, 3, 83, "Output",ExpressionUUID->"3cfc20a9-71c4-4427-9e81-ea5088caa9d2"]
}, Open  ]],
Cell[37471, 1142, 441, 7, 84, "Text",ExpressionUUID->"04d5c83f-718b-43f3-890e-1ad51848ce57"],
Cell[CellGroupData[{
Cell[37937, 1153, 504, 17, 175, "Input",ExpressionUUID->"e18fcc72-c7e6-465c-9def-f9a73f96c2c7"],
Cell[38444, 1172, 253, 7, 104, "Output",ExpressionUUID->"68b87c5f-f324-46a1-ba0a-75c18d222506"]
}, Open  ]],
Cell[38712, 1182, 431, 7, 84, "Text",ExpressionUUID->"0f0bec00-8945-4203-a651-8edeca403ab4"],
Cell[CellGroupData[{
Cell[39168, 1193, 421, 11, 212, "Input",ExpressionUUID->"e5bc3382-3bcb-4df7-b218-610d9064ceee"],
Cell[39592, 1206, 177, 3, 83, "Output",ExpressionUUID->"d93d79f1-fcc3-4b1f-9eb7-14ee2aa83867"],
Cell[39772, 1211, 298, 8, 105, "Output",ExpressionUUID->"b255e7cc-526e-4ef7-a937-ddd414231fa5"]
}, Open  ]],
Cell[40085, 1222, 451, 7, 84, "Text",ExpressionUUID->"163a999e-599c-4cf0-8dec-1b2cfb95e838"],
Cell[CellGroupData[{
Cell[40561, 1233, 465, 13, 212, "Input",ExpressionUUID->"ba6c0166-0203-4e61-af86-0856504fcbb0"],
Cell[41029, 1248, 191, 4, 83, "Output",ExpressionUUID->"379f0b26-ba6b-4f9f-92b3-f3afa63b7de7"],
Cell[41223, 1254, 367, 12, 116, "Output",ExpressionUUID->"9d79c30d-45cc-49d2-ae27-32db92ebf7e3"]
}, Open  ]],
Cell[41605, 1269, 458, 7, 84, "Text",ExpressionUUID->"94c35656-bab4-471e-a510-1fc1a4de7fac"],
Cell[CellGroupData[{
Cell[42088, 1280, 621, 18, 259, "Input",ExpressionUUID->"f9c6a6b9-4f2d-487e-8f27-ebb7bd0a42de"],
Cell[42712, 1300, 175, 4, 83, "Output",ExpressionUUID->"907ee61c-22c3-4265-8e1e-67e43874e5da"],
Cell[42890, 1306, 228, 6, 83, "Output",ExpressionUUID->"8b049ec1-48e8-4b96-8dd9-7006416339a0"]
}, Open  ]],
Cell[43133, 1315, 437, 7, 84, "Text",ExpressionUUID->"bd1ddfdb-ee87-4160-b204-373596a29bd0"],
Cell[CellGroupData[{
Cell[43595, 1326, 653, 20, 226, "Input",ExpressionUUID->"0bf6e133-117d-49a1-a215-08e39447d545"],
Cell[44251, 1348, 273, 8, 104, "Output",ExpressionUUID->"78eae2cd-dd96-487f-ac9e-707a1c2fa5c7"],
Cell[44527, 1358, 295, 9, 104, "Output",ExpressionUUID->"3c0e8a66-8893-4eb9-b96c-68446bf1c7ab"]
}, Open  ]],
Cell[44837, 1370, 455, 7, 84, "Text",ExpressionUUID->"53871e3b-4fef-4e2a-82be-7a8d3c7119a2"],
Cell[CellGroupData[{
Cell[45317, 1381, 801, 25, 296, "Input",ExpressionUUID->"2f100758-4096-472c-91c1-8d289c3f535d"],
Cell[46121, 1408, 238, 6, 115, "Output",ExpressionUUID->"3ba3ce59-eb95-4593-b357-db8a9c6da614"],
Cell[46362, 1416, 224, 4, 83, "Output",ExpressionUUID->"ef1132dd-e11a-4e7c-929e-65aaead7ccb4"]
}, Open  ]],
Cell[46601, 1423, 435, 7, 84, "Text",ExpressionUUID->"d698692a-29bc-43fd-a968-cd90114afad4"],
Cell[CellGroupData[{
Cell[47061, 1434, 859, 25, 347, "Input",ExpressionUUID->"6b0bbef7-f647-45e1-8684-87cfaa627ca9"],
Cell[47923, 1461, 213, 5, 104, "Output",ExpressionUUID->"9ae4955d-98b4-402c-a8ad-747023d3d92c"],
Cell[48139, 1468, 209, 5, 116, "Output",ExpressionUUID->"c1227185-4888-4973-86a8-8d5bfe439df4"],
Cell[48351, 1475, 229, 6, 135, "Output",ExpressionUUID->"87ff4b41-e0d9-41b7-8b97-f5978e4ab118"]
}, Open  ]],
Cell[48595, 1484, 154, 3, 73, "Input",ExpressionUUID->"dd2dfb49-f915-4a62-a1e3-9fb003a21763"],
Cell[48752, 1489, 456, 7, 84, "Text",ExpressionUUID->"7e542ce2-be7b-41cc-a6f8-ad8e70060ed8"],
Cell[49211, 1498, 1111, 33, 317, "Text",ExpressionUUID->"4d822c3d-1ad5-4605-8ec1-14f99d87415f"],
Cell[CellGroupData[{
Cell[50347, 1535, 1199, 36, 422, "Input",ExpressionUUID->"fe02086d-e42b-4990-9db3-263b18af2bd5"],
Cell[51549, 1573, 340, 11, 115, "Output",ExpressionUUID->"72e283b7-c46e-4fc6-ad15-d4b55a07c10e"],
Cell[51892, 1586, 194, 3, 83, "Output",ExpressionUUID->"75f5e9df-2384-4aee-832b-4de612dd6dcc"],
Cell[52089, 1591, 197, 3, 83, "Output",ExpressionUUID->"0d2bf8fd-db1c-4b8f-8d90-549e79bc444f"],
Cell[52289, 1596, 195, 3, 83, "Output",ExpressionUUID->"fdf14316-3977-42cb-babe-234666812e53"]
}, Open  ]],
Cell[52499, 1602, 469, 7, 84, "Text",ExpressionUUID->"48a70ce9-11f4-4042-8ff5-46e36e91a66a"],
Cell[CellGroupData[{
Cell[52993, 1613, 1094, 35, 449, "Input",ExpressionUUID->"0d648433-e3a0-49c9-8c47-fdb674124481"],
Cell[54090, 1650, 302, 8, 104, "Output",ExpressionUUID->"1bc8ded5-5d84-47fa-8b89-49ea7141d2e9"],
Cell[54395, 1660, 322, 9, 104, "Output",ExpressionUUID->"65036961-7ee8-46b6-87dd-35c877d979a1"],
Cell[54720, 1671, 261, 7, 115, "Output",ExpressionUUID->"e7b76616-27a3-4f45-b1ab-a4f310e86586"],
Cell[54984, 1680, 220, 4, 83, "Output",ExpressionUUID->"17ef89f9-2728-4902-b5af-ff633c2eb892"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55253, 1690, 450, 7, 165, "Section",ExpressionUUID->"af5dd942-c7d8-4bd8-8420-19ec64c957eb"],
Cell[55706, 1699, 422, 6, 84, "Text",ExpressionUUID->"6574cb87-c7b1-4b3e-920c-c36a4469d4cb"],
Cell[CellGroupData[{
Cell[56153, 1709, 498, 15, 207, "Input",ExpressionUUID->"b4c590ee-fe9d-4418-a9fd-07ded606d155"],
Cell[56654, 1726, 248, 7, 83, "Output",ExpressionUUID->"a45a00e7-6d25-41e3-8fa1-3bff7761055f"]
}, Open  ]],
Cell[56917, 1736, 436, 7, 84, "Text",ExpressionUUID->"ba6a160b-9c3c-4dc7-a3a9-de5fb4493417"],
Cell[CellGroupData[{
Cell[57378, 1747, 598, 17, 315, "Input",ExpressionUUID->"322c7c58-247e-4b00-8036-79c5b5d0d6a2"],
Cell[57979, 1766, 227, 6, 83, "Output",ExpressionUUID->"045b018f-1ee3-4ae8-80d7-7158992bf33a"],
Cell[58209, 1774, 153, 3, 83, "Output",ExpressionUUID->"8db4b832-7dbf-4c2d-b9c1-cdcbbe7146a1"],
Cell[58365, 1779, 155, 3, 83, "Output",ExpressionUUID->"cc01a4b7-7355-46d1-8d14-5003ef6cce57"]
}, Open  ]],
Cell[58535, 1785, 450, 7, 84, "Text",ExpressionUUID->"8c28b97a-2583-45a4-9cb4-2f763516a293"],
Cell[CellGroupData[{
Cell[59010, 1796, 585, 17, 296, "Input",ExpressionUUID->"f4478518-0384-4bc8-8b73-98f6cbfe12db"],
Cell[59598, 1815, 229, 6, 83, "Output",ExpressionUUID->"7014226c-e8ad-4779-b6b0-86c3f868cf75"],
Cell[59830, 1823, 167, 4, 83, "Output",ExpressionUUID->"e37ed5d0-f9c0-40fa-8040-2ea25f5be438"]
}, Open  ]],
Cell[60012, 1830, 438, 7, 84, "Text",ExpressionUUID->"bf2dd9db-c185-4c39-8c35-6c977d921e34"],
Cell[CellGroupData[{
Cell[60475, 1841, 713, 22, 347, "Input",ExpressionUUID->"e2124730-511b-4ac4-be98-98fc50ac973a"],
Cell[61191, 1865, 249, 6, 83, "Output",ExpressionUUID->"f65262ae-5c02-4e20-a4d3-0052b56d14b7"],
Cell[61443, 1873, 251, 6, 84, "Output",ExpressionUUID->"b471ef5d-3f99-4cd0-83e9-829bbda6001c"]
}, Open  ]],
Cell[61709, 1882, 454, 7, 84, "Text",ExpressionUUID->"8baf1e2e-68a9-449b-bc19-1fb535c69f71"],
Cell[CellGroupData[{
Cell[62188, 1893, 843, 26, 449, "Input",ExpressionUUID->"c2d5700f-0ba0-4a45-9ba5-004e3ed7021c"],
Cell[63034, 1921, 249, 6, 83, "Output",ExpressionUUID->"703b2c33-7348-482c-a839-9aecc916d14d"],
Cell[63286, 1929, 249, 6, 83, "Output",ExpressionUUID->"5e5d9878-cf45-4593-bb45-69ee68df707c"],
Cell[63538, 1937, 289, 8, 83, "Output",ExpressionUUID->"657e4ad6-b2b9-4425-a45c-ea420beb0935"],
Cell[63830, 1947, 207, 5, 122, "Output",ExpressionUUID->"e72ee88d-23b3-4eec-a1f9-f254e605a7c7"]
}, Open  ]],
Cell[64052, 1955, 442, 7, 84, "Text",ExpressionUUID->"f94153ee-9bec-41b5-8147-398ac92a94f9"],
Cell[CellGroupData[{
Cell[64519, 1966, 629, 18, 296, "Input",ExpressionUUID->"35915402-5798-460c-8666-d841a98c9157"],
Cell[65151, 1986, 251, 6, 83, "Output",ExpressionUUID->"c0943728-e16e-4be7-bb4b-19a8de2c0550"],
Cell[65405, 1994, 363, 12, 130, "Output",ExpressionUUID->"75fa6671-19d8-41f6-87b3-0c6b7cd3aa48"]
}, Open  ]],
Cell[65783, 2009, 447, 7, 84, "Text",ExpressionUUID->"c0e8acd9-6b5a-4c93-a1f8-898050d4e9df"],
Cell[CellGroupData[{
Cell[66255, 2020, 693, 21, 347, "Input",ExpressionUUID->"99464b06-d6a8-44f4-b1a3-496630ddb488"],
Cell[66951, 2043, 251, 6, 83, "Output",ExpressionUUID->"7862a359-2bf3-4b18-af6a-016c4d545703"],
Cell[67205, 2051, 177, 3, 83, "Output",ExpressionUUID->"78521564-8ce2-41c9-ba9e-f61ff8c88c76"]
}, Open  ]],
Cell[67397, 2057, 446, 7, 84, "Text",ExpressionUUID->"26f24df3-e2c2-45bf-b6ed-805d16399037"],
Cell[CellGroupData[{
Cell[67868, 2068, 870, 27, 454, "Input",ExpressionUUID->"6fa4eddb-6c70-45d1-a396-fd18185a21c3"],
Cell[68741, 2097, 245, 7, 83, "Output",ExpressionUUID->"b635a5a0-0101-43fd-a587-adafa39c0c01"],
Cell[68989, 2106, 227, 6, 83, "Output",ExpressionUUID->"69c9e4fb-5acf-48a0-bb4e-8f00a75c2c30"],
Cell[69219, 2114, 154, 3, 83, "Output",ExpressionUUID->"dce552b1-c4fd-4db9-9153-11c443330a6e"],
Cell[69376, 2119, 156, 3, 83, "Output",ExpressionUUID->"f7e11c91-1aae-4209-b4f5-55c7ed92b9a3"]
}, Open  ]],
Cell[69547, 2125, 434, 7, 84, "Text",ExpressionUUID->"e6159bf1-ad23-49a4-9da4-cefd61564ffc"],
Cell[CellGroupData[{
Cell[70006, 2136, 1147, 31, 487, "Input",ExpressionUUID->"e342ad4f-9686-433c-846a-dd0465d450e4"],
Cell[71156, 2169, 501, 11, 83, "Output",ExpressionUUID->"6c38c1ed-d7b3-4db8-b317-310600d13543"],
Cell[71660, 2182, 532, 12, 83, "Output",ExpressionUUID->"961b01c9-c810-4edb-b545-23531c142b27"],
Cell[72195, 2196, 442, 9, 83, "Output",ExpressionUUID->"f75e2e27-0a8d-44e2-9972-988a52e1c967"]
}, Open  ]],
Cell[72652, 2208, 453, 7, 84, "Text",ExpressionUUID->"8adb4b62-67c8-4520-b80e-8421374932c7"],
Cell[CellGroupData[{
Cell[73130, 2219, 473, 14, 175, "Input",ExpressionUUID->"a22c3662-6ae5-4c36-9782-25223e965104"],
Cell[73606, 2235, 153, 3, 83, "Output",ExpressionUUID->"b06df7dd-3780-4d4e-906a-500985c88353"]
}, Open  ]],
Cell[73774, 2241, 205, 4, 84, "Text",ExpressionUUID->"cc788f00-8804-4105-9534-ffb810efdf49"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74016, 2250, 439, 6, 165, "Section",ExpressionUUID->"2789ca2a-e041-4afc-8f33-b77376725dc9"],
Cell[74458, 2258, 428, 6, 84, "Text",ExpressionUUID->"69990c91-64a8-4235-8bfa-180b905d262a"],
Cell[CellGroupData[{
Cell[74911, 2268, 873, 28, 449, "Input",ExpressionUUID->"a5541379-4b74-400e-b469-fa7a87914faf"],
Cell[75787, 2298, 212, 5, 121, "Output",ExpressionUUID->"1d33374a-5443-4096-950c-ef3c951f2486"]
}, Open  ]],
Cell[76014, 2306, 434, 7, 84, "Text",ExpressionUUID->"35194434-9448-416e-b878-891d9ed920d4"],
Cell[CellGroupData[{
Cell[76473, 2317, 1030, 35, 463, "Input",ExpressionUUID->"08460816-172a-4c5d-992c-2fffaa6cff56"],
Cell[77506, 2354, 173, 4, 104, "Output",ExpressionUUID->"7788f2df-adb0-44b0-9461-109582acb048"]
}, Open  ]],
Cell[77694, 2361, 430, 7, 84, "Text",ExpressionUUID->"efe95b09-a610-49ab-bf7b-d8c83740009c"],
Cell[CellGroupData[{
Cell[78149, 2372, 912, 29, 449, "Input",ExpressionUUID->"3cc11143-9a85-4446-b11e-0550f1314586"],
Cell[79064, 2403, 251, 6, 83, "Output",ExpressionUUID->"5402f3d5-82e7-47a7-8d1f-522bb8e0f823"],
Cell[79318, 2411, 180, 3, 83, "Output",ExpressionUUID->"85eb88d5-676e-4800-b636-e1c1b2ecc008"]
}, Open  ]],
Cell[79513, 2417, 436, 7, 84, "Text",ExpressionUUID->"16d95082-088f-47e7-8763-3e97ae952260"],
Cell[CellGroupData[{
Cell[79974, 2428, 878, 28, 398, "Input",ExpressionUUID->"2bc7efb7-7146-4528-bd21-2836a11ba551"],
Cell[80855, 2458, 166, 4, 83, "Output",ExpressionUUID->"a6d5e06a-6a59-4dc3-864e-c1fea811239e"]
}, Open  ]],
Cell[81036, 2465, 438, 7, 84, "Text",ExpressionUUID->"608faf7a-8781-48e7-8e5d-2badd74bb619"],
Cell[CellGroupData[{
Cell[81499, 2476, 707, 21, 259, "Input",ExpressionUUID->"73ed53ff-45ab-4055-b49b-febd33498af0"],
Cell[82209, 2499, 197, 4, 104, "Output",ExpressionUUID->"c567c080-8875-492b-9be5-24f534ac61cb"]
}, Open  ]],
Cell[82421, 2506, 447, 7, 84, "Text",ExpressionUUID->"e8a422f1-f22e-497c-9ec2-6d45057b4ef9"],
Cell[CellGroupData[{
Cell[82893, 2517, 991, 31, 436, "Input",ExpressionUUID->"fff8527c-6ad1-4984-b195-6e34505067ee"],
Cell[83887, 2550, 204, 4, 83, "Output",ExpressionUUID->"07a49a52-3187-4efd-a2d9-d3e15a0ed7e3"]
}, Open  ]],
Cell[84106, 2557, 447, 7, 84, "Text",ExpressionUUID->"2d169ab2-e2b3-402f-997d-355d31e6388e"],
Cell[CellGroupData[{
Cell[84578, 2568, 688, 21, 161, "Input",ExpressionUUID->"4efa9670-a5eb-4f0f-9737-608658a86db6"],
Cell[85269, 2591, 229, 6, 83, "Output",ExpressionUUID->"72ce5c82-83bb-41b1-ad82-ee1f10d6cc16"]
}, Open  ]],
Cell[85513, 2600, 437, 7, 84, "Text",ExpressionUUID->"fdf6dd99-e888-4e9a-9d98-3d20f5674e9b"],
Cell[CellGroupData[{
Cell[85975, 2611, 1701, 47, 538, "Input",ExpressionUUID->"8ce88d5a-b24f-4626-8602-07ff1ed28d17"],
Cell[87679, 2660, 334, 6, 83, "Output",ExpressionUUID->"f54dd372-9754-4c38-887a-6348faedd0aa"],
Cell[88016, 2668, 328, 6, 84, "Output",ExpressionUUID->"bb41f670-1e37-407c-9635-a2217b8d2bed"]
}, Open  ]],
Cell[88359, 2677, 457, 7, 84, "Text",ExpressionUUID->"4732a54f-ec86-4e06-a49d-a27f129e2ad5"],
Cell[CellGroupData[{
Cell[88841, 2688, 1064, 32, 398, "Input",ExpressionUUID->"4a7c8861-e0e0-4d8a-9178-8a2fad784905"],
Cell[89908, 2722, 324, 9, 83, "Output",ExpressionUUID->"0339c73e-7f79-4905-b130-83493c84b6c8"]
}, Open  ]],
Cell[90247, 2734, 443, 7, 84, "Text",ExpressionUUID->"da14dfea-c4e5-4afe-b167-3cc457feaaf7"],
Cell[CellGroupData[{
Cell[90715, 2745, 1931, 60, 505, "Input",ExpressionUUID->"63ed080d-da70-4893-a582-b89cc37f8ca9"],
Cell[92649, 2807, 1124, 36, 144, "Output",ExpressionUUID->"23fa301d-c0b5-49ba-9630-52c29327882d"],
Cell[93776, 2845, 516, 16, 114, "Output",ExpressionUUID->"cba9f63e-b698-42ab-b7f5-d8dd3a7438ca"],
Cell[94295, 2863, 321, 9, 104, "Output",ExpressionUUID->"e6bf8dc0-64c0-4652-829f-9efb522d3a08"],
Cell[94619, 2874, 251, 7, 114, "Output",ExpressionUUID->"7572e882-f063-489d-92de-ac176b854906"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[94919, 2887, 469, 7, 165, "Section",ExpressionUUID->"d78bddbb-eb89-4c2b-99f7-77202085bb1f"],
Cell[95391, 2896, 427, 6, 84, "Text",ExpressionUUID->"355f9366-5d57-4aec-af5c-dd9a9217ad49"],
Cell[CellGroupData[{
Cell[95843, 2906, 619, 17, 226, "Input",ExpressionUUID->"a7d90461-9d17-490c-a77d-37b3cc490806"],
Cell[96465, 2925, 279, 7, 83, "Output",ExpressionUUID->"4f929b1d-0406-4a91-abd4-5b02ed73b0a5"],
Cell[96747, 2934, 427, 13, 83, "Output",ExpressionUUID->"095e85f5-4c11-401e-97f3-96deb734cfff"]
}, Open  ]],
Cell[97189, 2950, 441, 7, 84, "Text",ExpressionUUID->"98f0ed6a-8695-4020-94c1-034862ea539c"],
Cell[CellGroupData[{
Cell[97655, 2961, 655, 19, 226, "Input",ExpressionUUID->"fd0f3435-fc6e-45d0-b76d-78c0cc4ff194"],
Cell[98313, 2982, 265, 7, 83, "Output",ExpressionUUID->"80cec4ef-f23d-490b-ada8-57ed12b1e6e9"]
}, Open  ]],
Cell[98593, 2992, 445, 7, 84, "Text",ExpressionUUID->"fbb7bae3-9e2c-4507-9104-28e4286ee206"],
Cell[CellGroupData[{
Cell[99063, 3003, 379, 11, 105, "Input",ExpressionUUID->"f1f7b384-5f69-4b07-bba8-b02d9eccb4ff"],
Cell[99445, 3016, 305, 9, 83, "Output",ExpressionUUID->"dfce4159-d13c-4883-9fc5-7d043474673a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99787, 3030, 887, 24, 315, "Input",ExpressionUUID->"f950b82a-6990-4b83-b45e-1aafcfd4ffca"],
Cell[100677, 3056, 325, 9, 83, "Output",ExpressionUUID->"bd0073cd-09d7-4720-9c05-6d0248e80458"],
Cell[101005, 3067, 400, 12, 83, "Output",ExpressionUUID->"730710c6-9baa-43cb-9e91-8129c853f375"]
}, Open  ]],
Cell[101420, 3082, 436, 7, 84, "Text",ExpressionUUID->"e3f3e31d-5d18-4480-b3bb-8adadf8376e5"],
Cell[CellGroupData[{
Cell[101881, 3093, 683, 21, 259, "Input",ExpressionUUID->"b29e97e4-79fe-454f-b195-56bcb6ecfa63"],
Cell[102567, 3116, 186, 5, 115, "Output",ExpressionUUID->"47f8516d-73bf-4bfe-a71f-150c6c0bf6e9"]
}, Open  ]],
Cell[102768, 3124, 447, 7, 84, "Text",ExpressionUUID->"f8723f94-be0e-4658-a16a-b0660c968c3e"],
Cell[CellGroupData[{
Cell[103240, 3135, 885, 27, 385, "Input",ExpressionUUID->"75119c49-467e-4258-b11d-9ff39ca92cd7"],
Cell[104128, 3164, 260, 7, 135, "Output",ExpressionUUID->"56708573-036d-4704-bc85-be1613aab2f6"],
Cell[104391, 3173, 221, 4, 83, "Output",ExpressionUUID->"794ffa9c-43de-4c15-8e9e-f1fbc7e421b9"]
}, Open  ]],
Cell[104627, 3180, 435, 7, 84, "Text",ExpressionUUID->"ce46e8df-a668-4de0-86f6-dc8df44d09a1"],
Cell[CellGroupData[{
Cell[105087, 3191, 1886, 53, 500, "Input",ExpressionUUID->"dbb9fc13-8b2b-4c3b-a7cc-d702c61b9de0"],
Cell[106976, 3246, 560, 14, 83, "Output",ExpressionUUID->"e93066b5-8449-415e-bd54-5f01e6b29aef"],
Cell[107539, 3262, 384, 8, 83, "Output",ExpressionUUID->"b7b85d3e-2788-443f-ae38-fc31073f947c"],
Cell[107926, 3272, 401, 9, 115, "Output",ExpressionUUID->"d506a530-2e66-482a-987d-1fd53b6173fb"]
}, Open  ]],
Cell[108342, 3284, 437, 7, 84, "Text",ExpressionUUID->"b20ea475-dee8-48ce-abef-13b2ba459989"],
Cell[CellGroupData[{
Cell[108804, 3295, 1095, 32, 417, "Input",ExpressionUUID->"be72bb6c-ee91-4767-b8a8-fe7079bbdd00"],
Cell[109902, 3329, 304, 8, 83, "Output",ExpressionUUID->"a12add64-27ed-44d8-8c68-22974493652a"]
}, Open  ]],
Cell[110221, 3340, 445, 7, 84, "Text",ExpressionUUID->"dbad2805-9369-4f3d-8a14-efb43364719d"],
Cell[CellGroupData[{
Cell[110691, 3351, 1050, 30, 315, "Input",ExpressionUUID->"8f6dd99c-fb75-4998-af61-b4b60e07a162"],
Cell[111744, 3383, 210, 5, 83, "Output",ExpressionUUID->"60bd1867-7421-4a16-9e9d-b8b64eabab3f"]
}, Open  ]],
Cell[111969, 3391, 461, 7, 84, "Text",ExpressionUUID->"5f7db296-3e2b-4e5c-a65c-ef1cd5cc374b"],
Cell[CellGroupData[{
Cell[112455, 3402, 1396, 40, 347, "Input",ExpressionUUID->"cb1a71b5-d7f4-454e-ace7-3c3eba013ab2"],
Cell[113854, 3444, 648, 17, 104, "Output",ExpressionUUID->"d232fdf7-bea1-4acc-8ace-d3ae75c53693"]
}, Open  ]],
Cell[114517, 3464, 448, 7, 84, "Text",ExpressionUUID->"5b83cb80-b023-4d1f-906c-f9431fa9e019"],
Cell[CellGroupData[{
Cell[114990, 3475, 847, 23, 315, "Input",ExpressionUUID->"847a619e-acff-4c61-85ab-027f6db3866b"],
Cell[115840, 3500, 274, 7, 83, "Output",ExpressionUUID->"c637b6d7-7a9c-49db-a67a-2c230b1fa138"],
Cell[116117, 3509, 354, 10, 84, "Output",ExpressionUUID->"dedc5cc3-c38f-455b-b411-336a44b48804"]
}, Open  ]]
}, Open  ]]
}
]
*)

